/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import org.jetbrains.annotations.NotNull;

public class RexNodeList
implements List<RexNode>,
RexNode {
    private final List<RexNode> delegate;
    private final DataType type = DataTypeFactory.instance.buildUnknownType();

    public RexNodeList(List<RexNode> delegate) {
        this.delegate = new ArrayList<RexNode>(delegate);
    }

    public RexNodeList() {
        this.delegate = new ArrayList<RexNode>();
    }

    public RexNodeList(int capacity) {
        this.delegate = new ArrayList<RexNode>(capacity);
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexNodeList(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexNodeList(this);
    }

    @Override
    public List<RexNode> getChildren() {
        return new ArrayList<RexNode>(this.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @NotNull
    public Iterator<RexNode> iterator() {
        return this.delegate.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(RexNode rexNode) {
        return this.delegate.add(rexNode);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends RexNode> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends RexNode> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<RexNode> operator) {
        this.delegate.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super RexNode> c) {
        this.delegate.sort(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public RexNode get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public RexNode set(int index, RexNode element) {
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, RexNode element) {
        this.delegate.add(index, element);
    }

    @Override
    public RexNode remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    @NotNull
    public ListIterator<RexNode> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<RexNode> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    @NotNull
    public List<RexNode> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    @Override
    public String getDigest() {
        if (this.delegate.size() <= 50) {
            ArrayList<String> stringList = new ArrayList<String>(this.delegate.size());
            for (RexNode rexNode : this.delegate) {
                stringList.add(rexNode.getDigest());
            }
            return '(' + String.join((CharSequence)",", stringList) + ')';
        }
        ArrayList<String> stringList = new ArrayList<String>(this.delegate.size());
        for (int i = 0; i <= 50; ++i) {
            stringList.add(this.delegate.get(i).getDigest());
        }
        return '(' + String.join((CharSequence)",", stringList) + "...)";
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexNodeList)) {
            return false;
        }
        RexNodeList o = other.cast(RexNodeList.class);
        if (this.size() != o.size()) {
            return false;
        }
        if (this.delegate == o.delegate) {
            return true;
        }
        for (int i = 0; i < this.delegate.size(); ++i) {
            if (this.get(i).deepEquals(o.get(i))) continue;
            return false;
        }
        return true;
    }
}

