/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class RexRangeRef
implements RexNode {
    private final DataType dataType;
    private final int index;

    public RexRangeRef(DataType dataType, int index) {
        this.dataType = dataType;
        this.index = index;
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexRangeRef(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexRangeRef(this);
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    @Override
    public String getDigest() {
        return "range:" + this.index;
    }

    @Override
    public boolean deepEquals(RexNode other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof RexRangeRef)) {
            return false;
        }
        RexRangeRef o = other.cast(RexRangeRef.class);
        return this.index == o.index && this.dataType.equals(o.dataType);
    }
}

