/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.rex;

import kd.bos.flydb.core.rel.RelNode;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeVisitor;
import kd.bos.flydb.core.rex.RexNodeVisitor1;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;

public class RexSubQuery
implements RexNode {
    private SqlOperator operator;
    private RelNode query;
    private DataType type;
    private String digest;

    public RexSubQuery(SqlOperator operator, RelNode query, DataType type) {
        this.operator = operator;
        this.query = query;
        this.type = type;
        this.buildDigest();
    }

    @Override
    public <T> T accept(RexNodeVisitor<T> visitor) {
        return visitor.visitRexSubQuery(this);
    }

    @Override
    public void accept(RexNodeVisitor1 visitor1) {
        visitor1.visitRexSubQuery(this);
    }

    public final void buildDigest() {
        this.digest = String.format("(%s)", this.query.toString());
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return this.operator.getKind();
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    public RelNode getQuery() {
        return this.query;
    }

    public void setQuery(RelNode query) {
        this.query = query;
        this.buildDigest();
    }

    public SqlOperator getOperator() {
        return this.operator;
    }
}

