/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.schema.Schema;
import kd.bos.flydb.core.schema.SchemaFactory;
import kd.bos.flydb.core.schema.cosmic.CosmicSchema;
import kd.bos.flydb.core.schema.metadata.SchemaInfo;
import kd.bos.flydb.manager.SuperQueryService;

public class FlyDBSchemaFactory
implements SchemaFactory {
    @Override
    public Schema getSchema(String schema) {
        SuperQueryService superQueryService = SuperQueryService.create();
        if (superQueryService.exist("cosmic_db", schema)) {
            return new CosmicSchema("cosmic_db", schema);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.SchemaNotExist, (Object[])new Object[]{"cosmic_db", schema});
    }

    @Override
    public List<SchemaInfo> listSchemas(Long userId, String database) {
        SuperQueryService manager = SuperQueryService.create();
        List schemas = manager.listSchemas(userId, database);
        ArrayList<SchemaInfo> schemaInfos = new ArrayList<SchemaInfo>();
        schemas.forEach(schemaEntity -> {
            SchemaInfo info = new SchemaInfo();
            info.setName(schemaEntity.getNumber());
            info.setAlias(schemaEntity.getName());
            info.setType(schemaEntity.getType());
            schemaInfos.add(info);
        });
        return schemaInfos;
    }
}

