/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.rel.TableScanTag;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.schema.FormAttribute;
import kd.bos.flydb.core.schema.Scanner;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.cosmic.CosmicFormAttribute;
import kd.bos.flydb.core.schema.cosmic.DataEntityPropertyParser;
import kd.bos.flydb.core.schema.cosmic.IDataEntityTypeProvider;
import kd.bos.flydb.core.schema.cosmic.sharding.ShardingEntityScannerBuilder;
import kd.bos.flydb.core.schema.cosmic.single.EntityScannerBuilder;
import kd.bos.flydb.core.schema.cosmic.translate.MetaEntityPropertyParser;
import kd.bos.flydb.core.schema.metadata.ColumnInfo;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.xdb.XDBConfig;

public class CosmicEntityTable
implements Table {
    private String schema;
    private List<String> name;
    private DataType dataType;
    private FormAttribute formAttribute;

    public CosmicEntityTable() {
    }

    public CosmicEntityTable(String schema, List<String> name) {
        this.name = new ArrayList<String>(name);
        this.schema = schema;
        this.initCosmicFormType();
    }

    public CosmicEntityTable(String schema, List<String> name, DataType dataType) {
        this.schema = schema;
        this.name = new ArrayList<String>(name);
        this.dataType = dataType;
        this.initCosmicFormType();
    }

    private void initCosmicFormType() {
        if (this.formAttribute == null) {
            IDataEntityType entityType = IDataEntityTypeProvider.get().load(this.name);
            this.formAttribute = new CosmicFormAttribute(entityType);
        }
    }

    private void initDataType() {
        if (this.dataType == null) {
            IDataEntityType entityType = IDataEntityTypeProvider.get().load(this.name);
            DataEntityPropertyParser parser = new DataEntityPropertyParser(String.join((CharSequence)".", this.name), entityType);
            this.dataType = parser.parse();
        }
    }

    @Override
    public List<String> getName() {
        return this.name;
    }

    @Override
    public List<String> fullyQualityName() {
        ArrayList<String> fullyQualityName = new ArrayList<String>(this.name.size() + 1);
        fullyQualityName.addAll(this.name);
        fullyQualityName.add(0, this.schema);
        return fullyQualityName;
    }

    @Override
    public DataType getDataType() {
        this.initDataType();
        return this.dataType;
    }

    @Override
    public DataType getObjectRelationDataType() {
        return null;
    }

    private void checkSlaveDBInput() {
        Context context = Contexts.get();
        if (!Boolean.parseBoolean(context.getConfig("flydb.forceSlaveDB"))) {
            return;
        }
        IDataEntityType dataEntityType = IDataEntityTypeProvider.get().load(this.name);
        String routeKey = dataEntityType.getDBRouteKey();
        String tenantId = context.getConfig(SessionContextOption.TenantId.key());
        String accountId = context.getConfig(SessionContextOption.AccountId.key());
        List dbConfigs = null;
        try {
            dbConfigs = DBConfig.loadFromDataCenter((String)tenantId, (String)routeKey, (String)accountId, (boolean)true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean hasSlaveDB = false;
        if (dbConfigs != null && !dbConfigs.isEmpty()) {
            for (DBConfig dbConfig : dbConfigs) {
                if (!dbConfig.isReadOnly() || dbConfig.getLoadFactor() <= 0) continue;
                hasSlaveDB = true;
                break;
            }
        }
        if (!hasSlaveDB) {
            throw Exceptions.of((ErrorCode)ErrorCode.RequireSlaveDB, (Object[])new Object[]{routeKey});
        }
    }

    @Override
    public Scanner createScanner(int[] project, RexNode filter) {
        this.checkSlaveDBInput();
        this.initDataType();
        ArrayList<RexNode> selectList = new ArrayList<RexNode>(project.length);
        List<DataTypeField> dataTypeFieldList = this.dataType.getFieldList();
        for (int i : project) {
            selectList.add(new RexInputRef(dataTypeFieldList.get(i).getType(), i));
        }
        EntityScannerBuilder builder = new EntityScannerBuilder(selectList, this.name, filter, this.dataType);
        return builder.build();
    }

    @Override
    public Scanner[] createScanners(int[] project, RexNode filter, IDataEntityType entityType) {
        this.checkSlaveDBInput();
        this.initDataType();
        String tableName = entityType.getAlias();
        try {
            String[] shardingTableNames = (String[])DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)entityType.getDBRouteKey()), (boolean)true, () -> XDBConfig.getTableManager().getShardingTable(tableName));
            if (shardingTableNames.length == 0) {
                return Collections.singletonList(this.createScanner(project, filter)).toArray(new Scanner[0]);
            }
            ArrayList<RexNode> selectList = new ArrayList<RexNode>(project.length);
            List<DataTypeField> dataTypeFieldList = this.dataType.getFieldList();
            for (int i : project) {
                selectList.add(new RexInputRef(dataTypeFieldList.get(i).getType(), i));
            }
            ShardingEntityScannerBuilder builder = new ShardingEntityScannerBuilder(selectList, this.name, filter, this.dataType, shardingTableNames);
            return builder.build();
        }
        catch (Exception e) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected1, (Object[])new Object[]{e.getMessage()});
        }
    }

    @Override
    public List<ColumnInfo> getColumnInfos() {
        MetaEntityPropertyParser metaParser = new MetaEntityPropertyParser(String.join((CharSequence)".", this.name), IDataEntityTypeProvider.get().load(this.name));
        Map<String, IDataEntityProperty> propertyMap = metaParser.getPropertyMap();
        List<DataTypeField> dataTypeFields = metaParser.getType().getFieldList();
        ArrayList<ColumnInfo> infos = new ArrayList<ColumnInfo>(dataTypeFields.size());
        for (int i = 0; i < dataTypeFields.size(); ++i) {
            DataTypeField field = dataTypeFields.get(i);
            ColumnInfo info = new ColumnInfo();
            info.setColumnSeq(String.valueOf(field.getIndex()));
            info.setColumnName(field.getName().toLowerCase(Locale.ENGLISH));
            info.setColumnType(field.getType().getTypeName().name().toLowerCase(Locale.ENGLISH));
            this.buildColumnInfo(propertyMap.get(field.getName()), info);
            infos.add(info);
        }
        return infos;
    }

    @Override
    public FormAttribute getFormAttribute() {
        return this.formAttribute;
    }

    @Override
    public boolean isAllowTableScanTag(TableScanTag tableScanTag) {
        return false;
    }

    @Override
    public void validate() {
        IDataEntityType entityType = IDataEntityTypeProvider.get().load(this.name);
        if (entityType.getAlias() == null || entityType.getAlias().trim().isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.EntityMissPhysicalTable, (Object[])new Object[]{this.name});
        }
    }

    private void buildColumnInfo(IDataEntityProperty property, ColumnInfo info) {
        if (property == null) {
            return;
        }
        String alias = property.getName();
        if (property.getDisplayName() != null && property.getDisplayName().getLocaleValue() != null) {
            alias = property.getDisplayName().getLocaleValue();
        }
        info.setColumnAlias(alias);
        if (property instanceof SubEntryProp) {
            ArrayList<String> name = new ArrayList<String>(3);
            name.add(property.getParent().getParent().getName());
            name.add(property.getParent().getName());
            name.add(property.getName());
            info.setColumnReference(String.join((CharSequence)".", name));
            info.setColumnTypeDesc(String.valueOf(FieldType.SUB_ENTRY.code));
        } else if (property instanceof EntryProp) {
            ArrayList<String> name = new ArrayList<String>(2);
            name.add(property.getParent().getName());
            name.add(property.getName());
            info.setColumnReference(String.join((CharSequence)".", name));
            info.setColumnTypeDesc(String.valueOf(FieldType.ENTRY.code));
        } else if (property.getClass() == ItemClassProp.class) {
            info.setColumnTypeDesc(String.valueOf(FieldType.MULTIPLE_CLASS_BASE_DATA.code));
        } else if (property instanceof BasedataProp) {
            info.setColumnReference(((BasedataProp)property).getBaseEntityId());
            info.setColumnTypeDesc(String.valueOf(FieldType.BASE_DATA.code));
        } else if (property instanceof MulBasedataProp) {
            info.setColumnReference(((MulBasedataProp)property).getBaseEntityId());
            info.setColumnTypeDesc(String.valueOf(FieldType.MULTIPLE_BASE_DATA.code));
        } else if (property instanceof ItemClassTypeProp) {
            info.setColumnTypeDesc(String.valueOf(FieldType.MULTIPLE_CLASS_BASE_DATA_TYPE.code));
        } else if (property instanceof IBasedataField) {
            info.setColumnReference(((IBasedataField)property).getBaseEntityId());
            info.setColumnTypeDesc(String.valueOf(FieldType.BASE_DATA.code));
        }
    }

    static enum FieldType {
        BASE_DATA(0, "BASE_DATA"),
        MULTIPLE_BASE_DATA(1, "MULTIPLE_BASE_DATA"),
        MULTIPLE_CLASS_BASE_DATA(2, "MULTIPLE_CLASS_BASE_DATA"),
        ENTRY(3, "ENTRY"),
        SUB_ENTRY(4, "SUB_ENTRY"),
        COMMON_MULTIPLE_LANGUAGE(5, "COMMON_MULTIPLE_LANGUAGE"),
        MULTIPLE_LANGUAGE(6, "MULTIPLE_LANGUAGE"),
        MULTIPLE_CLASS_BASE_DATA_TYPE(7, "MULTIPLE_CLASS_BASE_DATA_TYPE"),
        REFERENCE_PARENT(98, "REFERENCE_PARENT"),
        UNKNOWN(99, "UNKNOWN");

        private final int code;
        private final String localName;

        private FieldType(Integer code, String localName) {
            this.code = code;
            this.localName = localName;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getLocalName() {
            return this.localName.toLowerCase();
        }
    }
}

