/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import kd.bos.flydb.core.schema.DialectSqlFactory;
import kd.bos.flydb.core.schema.Schema;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.cosmic.CosmicEntityTable;
import kd.bos.flydb.core.schema.cosmic.IDataEntityTypeProvider;
import kd.bos.flydb.core.schema.metadata.TableInfo;
import kd.bos.flydb.manager.SuperQueryService;

public class CosmicSchema
implements Schema {
    private String database;
    private String name;
    private static final String tableType = "entity";

    public CosmicSchema() {
    }

    public CosmicSchema(String database, String name) {
        this.database = database;
        this.name = name;
        Objects.requireNonNull(database, "Database name can not be null or empty.");
        Objects.requireNonNull(name, "Schema name can not be null or empty.");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Table getTable(List<String> tableName) {
        try {
            String entityName = String.join((CharSequence)".", tableName);
            entityName = entityName.toLowerCase(Locale.ENGLISH);
            IDataEntityTypeProvider.get().load(tableName);
            return new CosmicEntityTable(this.name, tableName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List<TableInfo> getTableInfos(String schema) {
        if (schema == null || "".equals(schema)) {
            schema = this.name;
        }
        schema = schema.toLowerCase(Locale.ENGLISH);
        SuperQueryService manager = SuperQueryService.create();
        List tables = manager.listTables(this.database, schema);
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        tables.forEach(entity -> {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName(entity.getNumber());
            tableInfo.setAlias(entity.getName());
            tableInfo.setType(entity.getType());
            tableInfos.add(tableInfo);
        });
        return tableInfos;
    }

    @Override
    public DialectSqlFactory getDialectSqlFactory() {
        return null;
    }
}

