/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypes;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.TupleDataType;

public class DataEntityPropertyParser {
    private static final DataTypeFactory basicDataTypeFactory = DataTypeFactory.instance;
    protected static final String PARENT_REFERENCE_PROPERTY_NAME = "_pid";
    protected final String name;
    protected final IDataEntityType entityType;
    protected final Map<String, IDataEntityProperty> propertyMap = new LinkedHashMap<String, IDataEntityProperty>();
    protected final Map<String, DataType> fields = new LinkedHashMap<String, DataType>();
    protected DataType type;

    public DataEntityPropertyParser(String name, IDataEntityType entityType) {
        this.entityType = entityType;
        this.name = name;
    }

    public DataType parse() {
        if (this.type != null) {
            return this.type;
        }
        this.wash();
        this.propertyMap.forEach((k, v) -> this.fields.put((String)k, this.getFieldType((IDataEntityProperty)v)));
        this.type = new TupleDataType(this.name, Lists.newArrayList(this.fields.keySet()), Lists.newArrayList(this.fields.values()));
        return this.type;
    }

    protected void wash() {
        for (IDataEntityProperty property : this.entityType.getProperties()) {
            if (property instanceof DynamicLocaleProperty) continue;
            this.propertyMap.put(property.getName(), property);
        }
        for (IDataEntityProperty property : this.entityType.getProperties()) {
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                this.propertyMap.remove(basedataProp.getRefIdPropName());
            }
            if (property instanceof GeoPointProp) {
                this.propertyMap.remove(property.getName());
            }
            if (property instanceof EntryProp) {
                this.propertyMap.remove(property.getName());
            }
            if (property.getAlias() != null && !property.getAlias().isEmpty()) continue;
            this.propertyMap.remove(property.getName());
        }
        if (this.entityType instanceof EntryType) {
            IDataEntityType parent = this.entityType.getParent();
            ISimpleProperty parentPrimaryProperty = parent.getPrimaryKey();
            this.fields.put(PARENT_REFERENCE_PROPERTY_NAME, this.createParentReferenceType((IDataEntityProperty)parentPrimaryProperty));
        }
    }

    protected DataType createParentReferenceType(IDataEntityProperty property) {
        DataType type1 = this.getFieldType(property);
        return CosmicDataTypes.createParentReference(type1.getTypeName());
    }

    protected DataType getFieldType(IDataEntityProperty property) {
        int dbType;
        if (property instanceof BasedataProp) {
            DataType dbType2 = this.dbTypeMapping(((BasedataProp)property).getDbType(), property.getName());
            return CosmicDataTypes.createBaseData(dbType2.getTypeName());
        }
        if (property instanceof MulBasedataProp) {
            DataType dbType3 = this.dbTypeMapping(((MulBasedataProp)property).getDbType(), property.getName());
            return CosmicDataTypes.createMultipleBaseData(dbType3.getTypeName());
        }
        if (property instanceof MuliLangTextProp) {
            MuliLangTextProp muliLangProperty = (MuliLangTextProp)property;
            boolean isGLang = muliLangProperty.isGL();
            return isGLang ? CosmicDataTypes.createCommonMultipleLanguage() : CosmicDataTypes.createMultipleLanguage();
        }
        if (property instanceof ISimpleProperty) {
            ISimpleProperty simpleProperty = (ISimpleProperty)property;
            dbType = simpleProperty.getDbType();
        } else if (property instanceof IFieldHandle) {
            IFieldHandle fieldHandle = (IFieldHandle)property;
            dbType = fieldHandle.getDbType();
        } else {
            throw new UnsupportedOperationException("Unknown property: " + property.getName() + " type.");
        }
        return this.dbTypeMapping(dbType, property.getName());
    }

    protected DataType dbTypeMapping(int dbType, String fieldName) {
        switch (dbType) {
            case 4: {
                return basicDataTypeFactory.buildInt();
            }
            case -9: 
            case 1: 
            case 12: {
                return basicDataTypeFactory.buildString();
            }
            case -5: {
                return basicDataTypeFactory.buildLong();
            }
            case 3: {
                return basicDataTypeFactory.buildDecimal(32, 10);
            }
            case 91: {
                return basicDataTypeFactory.buildDate();
            }
            case 93: {
                return basicDataTypeFactory.buildDatetime();
            }
        }
        throw new UnsupportedOperationException("Unknown field: " + fieldName + " type.");
    }
}

