/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic;

import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.orm.ORM;

public class IDataEntityTypeProvider {
    private static final ThreadLocal<IDataEntityTypeProvider> PROVIDER_THREAD_LOCAL = ThreadLocal.withInitial(new Supplier<IDataEntityTypeProvider>(){

        @Override
        public IDataEntityTypeProvider get() {
            return new IDataEntityTypeProvider();
        }
    });
    private final HashMap<String, IDataEntityType> cache = new HashMap();

    public static IDataEntityTypeProvider get() {
        return PROVIDER_THREAD_LOCAL.get();
    }

    public IDataEntityType load(List<String> names) {
        String fullyKey = String.join((CharSequence)".", names);
        IDataEntityType result = this.cache.get(fullyKey);
        if (result != null) {
            return result;
        }
        if (names.size() > 4) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedTableName, (Object[])new Object[]{String.join((CharSequence)".", names)});
        }
        if (names.size() == 1) {
            result = ORM.create().getDataEntityType(names.get(0));
            this.cache.put(names.get(0), result);
            return result;
        }
        String subKey = String.join((CharSequence)".", names.subList(0, names.size() - 1));
        IDataEntityType entityType = ORM.create().getDataEntityType(subKey);
        this.cache.put(subKey, entityType);
        IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)names.get(names.size() - 1));
        if (property instanceof MulBasedataProp) {
            MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
            result = ORM.create().getDataEntityType(mulBasedataProp.getBaseEntityId());
        } else {
            result = ORM.create().getDataEntityType(fullyKey);
        }
        this.cache.put(fullyKey, result);
        return result;
    }
}

