/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.sharding;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.db.DB;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.schema.cosmic.single.TableNameHelp;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicEntity;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.xdb.tablemanager.TableName;

public class ShardingCosmicEntity
extends CosmicEntity {
    public ShardingCosmicEntity(EntityPropertyHelper helper) {
        super(helper);
    }

    public void printFromShardingTable(SqlSegmentBuilder.ClauseBuilder builder, long shardingIndex) {
        builder.appendBlankSpace();
        HashMap tables = new HashMap(this.tables);
        ArrayList keys = new ArrayList(tables.keySet());
        String mainTableName = this.helper.getMainTableName();
        keys.sort((o1, o2) -> {
            if (o1.equalsIgnoreCase(mainTableName)) {
                return -1;
            }
            if (o2.equalsIgnoreCase(mainTableName)) {
                return 1;
            }
            return o1.compareToIgnoreCase((String)o2);
        });
        StringBuilder joinBuilder = new StringBuilder();
        String firstTable = (String)keys.get(0);
        TableName firstTableName = TableName.of((String)firstTable);
        String firstTablePrimary = TableNameHelp.createTablePrefix((Integer)tables.get(firstTable)) + '.' + this.pk.getAlias();
        String primaryColumnName = this.pk.getAlias();
        joinBuilder.append(TableNameHelp.createTableAlias(firstTableName.getShardingTable(shardingIndex), (Integer)tables.get(firstTable)));
        for (int i = 1; i < keys.size(); ++i) {
            joinBuilder.append(' ');
            String key = (String)keys.get(i);
            boolean sharded = DB.isSharded((String)key);
            String tableAlias = sharded ? TableNameHelp.createTableAlias(TableName.of((String)key).getShardingTable(shardingIndex), (Integer)tables.get(key)) : TableNameHelp.createTableAlias(key, (Integer)tables.get(key));
            if (key.equalsIgnoreCase(this.langTableName)) {
                String tablePrefix = TableNameHelp.createTablePrefix((Integer)tables.get(key));
                Context context = Contexts.get();
                joinBuilder.append(String.format("LEFT JOIN %s ON %s.%s = %s AND %s.flocaleid = '%s'", tableAlias, tablePrefix, primaryColumnName, firstTablePrimary, tablePrefix, context.getConfig(SessionContextOption.LanguageEnv.key())));
                continue;
            }
            joinBuilder.append(String.format("LEFT JOIN %s ON %s.%s = %s", tableAlias, TableNameHelp.createTablePrefix((Integer)tables.get(key)), primaryColumnName, firstTablePrimary));
        }
        builder.append(joinBuilder.toString());
    }
}

