/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.sharding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.flydb.core.rex.BaseRexNodeVisitor1;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.schema.cosmic.IDataEntityTypeProvider;
import kd.bos.flydb.core.schema.cosmic.sharding.ShardingCosmicEntity;
import kd.bos.flydb.core.schema.cosmic.sharding.ShardingSingleEntityScanner;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.KSQLDialectSqlPrinter;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;
import kd.bos.xdb.tablemanager.TableName;

public class ShardingEntityScannerBuilder {
    private final List<RexNode> selectList;
    private final RexNode filter;
    private final DataType type;
    private final ShardingCosmicEntity entity;
    String[] shardingTableNames;

    public ShardingEntityScannerBuilder(List<RexNode> selectList, List<String> entityName, RexNode filter, DataType type, String[] shardingTableNames) {
        this.selectList = selectList;
        this.filter = filter;
        this.type = type;
        String name = String.join((CharSequence)".", entityName);
        IDataEntityType entityType = IDataEntityTypeProvider.get().load(entityName);
        assert (shardingTableNames.length != 0);
        this.shardingTableNames = shardingTableNames;
        this.entity = new ShardingCosmicEntity(new EntityPropertyHelper(name, entityType));
    }

    public ShardingSingleEntityScanner[] build() {
        ShardingSingleEntityScanner[] scanners = new ShardingSingleEntityScanner[this.shardingTableNames.length];
        for (int i = 0; i < this.shardingTableNames.length; ++i) {
            PropertyCollector propertyCollector = new PropertyCollector(this.type);
            for (RexNode rexNode : this.selectList) {
                rexNode.accept(propertyCollector);
            }
            if (this.filter != null) {
                this.filter.accept(propertyCollector);
            }
            this.entity.scan(propertyCollector.getPropertyList());
            SqlSegmentBuilder sqlSegmentBuilder = new SqlSegmentBuilder();
            sqlSegmentBuilder.selectList.newSegment(false);
            KSQLDialectSqlPrinter selectListPrinter = new KSQLDialectSqlPrinter(sqlSegmentBuilder.selectList, SqlSegmentBuilder.Clause.SELECT_LIST, this.entity);
            ArrayList<String> outFieldNameList = new ArrayList<String>(this.selectList.size());
            ArrayList<DataType> outFieldTypeList = new ArrayList<DataType>(this.selectList.size());
            int ordinal = 0;
            for (RexNode item : this.selectList) {
                item.accept(selectListPrinter);
                selectListPrinter.printKeyword(",");
                outFieldNameList.add(SqlValidateUtil.getAlias(this.type, item, ordinal));
                outFieldTypeList.add(item.getType());
                ++ordinal;
            }
            selectListPrinter.deleteLastChar();
            sqlSegmentBuilder.from.newSegment(false);
            this.entity.printFromShardingTable(sqlSegmentBuilder.from, TableName.of((String)this.shardingTableNames[i]).getShardingIndex());
            if (this.filter != null) {
                KSQLDialectSqlPrinter wherePrinter = new KSQLDialectSqlPrinter(sqlSegmentBuilder.where, SqlSegmentBuilder.Clause.WHERE, this.entity);
                sqlSegmentBuilder.where.newSegment(false);
                this.filter.accept(wherePrinter);
            }
            TupleDataType outType = new TupleDataType("ScannerTuple", outFieldNameList, outFieldTypeList);
            scanners[i] = new ShardingSingleEntityScanner(this.entity.getRouteKey(), outType, true, sqlSegmentBuilder);
        }
        return scanners;
    }

    private static class PropertyCollector
    extends BaseRexNodeVisitor1 {
        private final Set<Integer> indexList = new HashSet<Integer>();
        private final DataType type;

        public PropertyCollector(DataType type) {
            this.type = type;
        }

        @Override
        public void visitRexInputRef(RexInputRef inputRef) {
            this.indexList.add(inputRef.getIndex());
        }

        public List<String> getPropertyList() {
            ArrayList<String> propertyNameList = new ArrayList<String>(this.indexList.size());
            List<DataTypeField> fieldList = this.type.getFieldList();
            for (Integer integer : this.indexList) {
                propertyNameList.add(fieldList.get(integer).getName());
            }
            return propertyNameList;
        }
    }
}

