/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.sharding;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.pktemptable.PKTempTable;
import kd.bos.db.pktemptable.PKTempTables;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.interpreter.algox.CompilerHelp;
import kd.bos.flydb.core.schema.Scanner;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegment;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.flydb.core.sql.type.DataTypeField;

public class ShardingSingleEntityScanner
implements Scanner {
    private static final String DIALECT_PREFIX = "/*dialect*/";
    private String route;
    private kd.bos.flydb.core.sql.type.DataType dataType;
    private boolean readonlyFirst;
    private SqlSegmentBuilder sqlSegmentBuilder;
    private ArrayList<AutoCloseable> _resources = new ArrayList();

    public ShardingSingleEntityScanner(String route, kd.bos.flydb.core.sql.type.DataType dataType, boolean readonlyFirst, SqlSegmentBuilder sqlSegmentBuilder) {
        this.route = route;
        this.dataType = dataType;
        this.readonlyFirst = readonlyFirst;
        this.sqlSegmentBuilder = sqlSegmentBuilder;
    }

    public ShardingSingleEntityScanner() {
    }

    @Override
    public Iterable<Object[]> scan() {
        return new InnerIterable(this);
    }

    @Override
    public kd.bos.flydb.core.sql.type.DataType getRowType() {
        return this.dataType;
    }

    @Override
    public void close() {
        if (this._resources == null) {
            return;
        }
        for (AutoCloseable resource : this._resources) {
            try {
                resource.close();
            }
            catch (Exception exception) {}
        }
    }

    private static ValueGetter[] buildGetter(kd.bos.flydb.core.sql.type.DataType type, RowMeta meta) {
        if (type.getFieldCount() != meta.getFieldCount()) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
        }
        ValueGetter[] getters = new ValueGetter[type.getFieldCount()];
        List<DataTypeField> fieldList = type.getFieldList();
        for (int i = 0; i < type.getFieldCount(); ++i) {
            DataType expectedType = CompilerHelp.convertBasicType(fieldList.get(i).getType());
            getters[i] = ShardingSingleEntityScanner.valueGetter(expectedType);
        }
        return getters;
    }

    private static ValueGetter valueGetter(DataType type) {
        if (type.ordinal == 2) {
            return IntValueGetter.instance;
        }
        if (type.ordinal == 1) {
            return StringValueGetter.instance;
        }
        if (type.ordinal == 3) {
            return LongValueGetter.instance;
        }
        if (type.ordinal == 5) {
            return BigDecimalGetter.instance;
        }
        if (type.ordinal == 6) {
            return DateGetter.instance;
        }
        if (type.ordinal == 7) {
            return TimestampGetter.instance;
        }
        return null;
    }

    private static class TimestampGetter
    implements ValueGetter {
        private static final TimestampGetter instance = new TimestampGetter();

        private TimestampGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            return row.getTimestamp(i);
        }
    }

    private static class DateGetter
    implements ValueGetter {
        private static final DateGetter instance = new DateGetter();

        private DateGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            java.util.Date src = row.getDate(i);
            if (src == null) {
                return null;
            }
            if (!src.getClass().equals(Date.class)) {
                return new Date(src.getTime());
            }
            return src;
        }
    }

    private static class BigDecimalGetter
    implements ValueGetter {
        private static final BigDecimalGetter instance = new BigDecimalGetter();

        private BigDecimalGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            return row.getBigDecimal(i);
        }
    }

    private static class LongValueGetter
    implements ValueGetter {
        private static final LongValueGetter instance = new LongValueGetter();

        private LongValueGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            return row.getLong(i);
        }
    }

    private static class StringValueGetter
    implements ValueGetter {
        private static final StringValueGetter instance = new StringValueGetter();

        private StringValueGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            return row.getString(i);
        }
    }

    private static class IntValueGetter
    implements ValueGetter {
        private static final IntValueGetter instance = new IntValueGetter();

        private IntValueGetter() {
        }

        @Override
        public Object convert(Row row, int i) {
            return row.getInteger(i);
        }
    }

    static interface ValueGetter {
        public Object convert(Row var1, int var2);
    }

    public static class DataSetIterator
    implements Iterator<Object[]> {
        RowMeta meta;
        DataSet dataSet;
        int fieldCount;
        kd.bos.flydb.core.sql.type.DataType type;
        ValueGetter[] getters;

        public DataSetIterator(RowMeta meta, DataSet dataSet, kd.bos.flydb.core.sql.type.DataType type) {
            this.meta = meta;
            this.dataSet = dataSet;
            this.fieldCount = meta.getFieldCount();
            this.type = type;
            this.getters = ShardingSingleEntityScanner.buildGetter(type, meta);
        }

        @Override
        public boolean hasNext() {
            return this.dataSet.hasNext();
        }

        @Override
        public Object[] next() {
            Row row = this.dataSet.next();
            Object[] r = new Object[this.fieldCount];
            for (int i = 0; i < this.fieldCount; ++i) {
                ValueGetter getter = this.getters[i];
                r[i] = getter != null ? getter.convert(row, i) : row.get(i);
            }
            return r;
        }
    }

    public static class InnerIterable
    implements Iterable<Object[]> {
        ShardingSingleEntityScanner scanner;

        public InnerIterable(ShardingSingleEntityScanner scanner) {
            this.scanner = scanner;
        }

        private boolean isToTemp(SqlSegment segment) {
            int maxSize = Integer.parseInt(System.getProperty("orm.opt.in.maxsize", "500000"));
            if (segment.params.size() > maxSize) {
                throw new KDException(BosErrorCode.bOS, new Object[]{"in query params length over the maximum:" + segment.params.size() + ">" + maxSize});
            }
            Object p = segment.params.get(0);
            return segment.params.size() >= Integer.parseInt(System.getProperty("orm.opt.in.threshold", "2000")) && Boolean.parseBoolean(System.getProperty("orm.opt.in.enable", "true")) && (p instanceof Long || p instanceof Integer || p instanceof String);
        }

        @Override
        public Iterator<Object[]> iterator() {
            DataSet dataSet;
            SqlSegmentBuilder builder = this.scanner.sqlSegmentBuilder;
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> params = new ArrayList<Object>();
            sql.append("SELECT ");
            for (SqlSegment segment : builder.selectList.getSegments()) {
                sql.append((CharSequence)segment.append);
                params.addAll(segment.params);
            }
            sql.append(" FROM ");
            for (SqlSegment segment : builder.from.getSegments()) {
                sql.append((CharSequence)segment.append);
                params.addAll(segment.params);
            }
            if (!builder.where.getSegments().isEmpty()) {
                sql.append(" WHERE ");
                for (SqlSegment segment : builder.where.getSegments()) {
                    if (segment.isIn) {
                        if (this.isToTemp(segment)) {
                            Object p = segment.params.get(0);
                            PKTempTable tempTable = p instanceof String ? PKTempTables.createPKBigString((DBRoute)DBRoute.of((String)this.scanner.route)) : PKTempTables.createPKLong((DBRoute)DBRoute.of((String)this.scanner.route));
                            sql.append("(SELECT FID FROM ").append(tempTable.getName()).append(")");
                            tempTable.insert(segment.params);
                            this.scanner._resources.add(tempTable);
                            continue;
                        }
                        sql.append((CharSequence)segment.append);
                        ArrayList<String> sqlPart = new ArrayList<String>(segment.params.size());
                        for (int i = 0; i < segment.params.size(); ++i) {
                            sqlPart.add("?");
                        }
                        sql.append('(').append(String.join((CharSequence)",", sqlPart)).append(')');
                        params.addAll(segment.params);
                        continue;
                    }
                    sql.append((CharSequence)segment.append);
                    params.addAll(segment.params);
                }
            }
            if (this.scanner.readonlyFirst) {
                try (ThreadReadWriteContext ignored = DB.beginThreadRead();){
                    dataSet = DB.queryDataSet((String)"ShardingSingleEntityScanner", (DBRoute)DBRoute.of((String)this.scanner.route), (String)(ShardingSingleEntityScanner.DIALECT_PREFIX + sql.toString()), (Object[])params.toArray());
                }
            } else {
                dataSet = DB.queryDataSet((String)"ShardingSingleEntityScanner", (DBRoute)DBRoute.of((String)this.scanner.route), (String)(ShardingSingleEntityScanner.DIALECT_PREFIX + sql.toString()), (Object[])params.toArray());
            }
            if (this.scanner._resources == null) {
                this.scanner._resources = new ArrayList();
            }
            this.scanner._resources.add(dataSet);
            return new DataSetIterator(dataSet.getRowMeta(), dataSet, this.scanner.dataType);
        }
    }
}

