/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.single;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.flydb.core.rex.BaseRexNodeVisitor1;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.schema.cosmic.IDataEntityTypeProvider;
import kd.bos.flydb.core.schema.cosmic.single.SingleEntityScanner;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicEntity;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.KSQLDialectSqlPrinter;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.util.SqlValidateUtil;

public class EntityScannerBuilder {
    private final List<RexNode> selectList;
    private final RexNode filter;
    private final DataType type;
    private final CosmicEntity entity;

    public EntityScannerBuilder(List<RexNode> selectList, List<String> entityName, RexNode filter, DataType type) {
        this.selectList = selectList;
        this.filter = filter;
        this.type = type;
        String name = String.join((CharSequence)".", entityName);
        IDataEntityType entityType = IDataEntityTypeProvider.get().load(entityName);
        this.entity = new CosmicEntity(new EntityPropertyHelper(name, entityType));
    }

    public SingleEntityScanner build() {
        PropertyCollector propertyCollector = new PropertyCollector(this.type);
        for (RexNode rexNode : this.selectList) {
            rexNode.accept(propertyCollector);
        }
        if (this.filter != null) {
            this.filter.accept(propertyCollector);
        }
        this.entity.scan(propertyCollector.getPropertyList());
        SqlSegmentBuilder sqlSegmentBuilder = new SqlSegmentBuilder();
        sqlSegmentBuilder.selectList.newSegment(false);
        KSQLDialectSqlPrinter selectListPrinter = new KSQLDialectSqlPrinter(sqlSegmentBuilder.selectList, SqlSegmentBuilder.Clause.SELECT_LIST, this.entity);
        ArrayList<String> outFieldNameList = new ArrayList<String>(this.selectList.size());
        ArrayList<DataType> outFieldTypeList = new ArrayList<DataType>(this.selectList.size());
        int ordinal = 0;
        for (RexNode item : this.selectList) {
            item.accept(selectListPrinter);
            selectListPrinter.printKeyword(",");
            outFieldNameList.add(SqlValidateUtil.getAlias(this.type, item, ordinal));
            outFieldTypeList.add(item.getType());
            ++ordinal;
        }
        selectListPrinter.deleteLastChar();
        sqlSegmentBuilder.from.newSegment(false);
        this.entity.printFrom(sqlSegmentBuilder.from);
        if (this.filter != null) {
            KSQLDialectSqlPrinter wherePrinter = new KSQLDialectSqlPrinter(sqlSegmentBuilder.where, SqlSegmentBuilder.Clause.WHERE, this.entity);
            sqlSegmentBuilder.where.newSegment(false);
            this.filter.accept(wherePrinter);
        }
        TupleDataType outType = new TupleDataType("ScannerTuple", outFieldNameList, outFieldTypeList);
        return new SingleEntityScanner(this.entity.getRouteKey(), outType, true, sqlSegmentBuilder);
    }

    private static class PropertyCollector
    extends BaseRexNodeVisitor1 {
        private final Set<Integer> indexList = new HashSet<Integer>();
        private final DataType type;

        public PropertyCollector(DataType type) {
            this.type = type;
        }

        @Override
        public void visitRexInputRef(RexInputRef inputRef) {
            this.indexList.add(inputRef.getIndex());
        }

        public List<String> getPropertyList() {
            ArrayList<String> propertyNameList = new ArrayList<String>(this.indexList.size());
            List<DataTypeField> fieldList = this.type.getFieldList();
            for (Integer integer : this.indexList) {
                propertyNameList.add(fieldList.get(integer).getName());
            }
            return propertyNameList;
        }
    }
}

