/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.flydb.common.SessionContextOption;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypeEnum;
import kd.bos.flydb.core.schema.cosmic.CosmicMappingDataType;
import kd.bos.flydb.core.schema.cosmic.single.TableNameHelp;
import kd.bos.flydb.core.schema.cosmic.translate.BasicCosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.GLangCosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.MultipleBaseDataCosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.ParentReferenceCosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.flydb.core.schema.cosmic.translate.Translator;
import kd.bos.flydb.core.sql.type.DataType;

public class CosmicEntity
implements Translator {
    protected final HashMap<String, Integer> tables = new HashMap();
    protected final ISimpleProperty pk;
    protected final int offset;
    private boolean appendGLang = false;
    protected String langTableName = null;
    protected final EntityPropertyHelper helper;
    protected static final String joinTemplate = "LEFT JOIN %s ON %s.%s = %s";
    protected static final String joinTemplateWithLang = "LEFT JOIN %s ON %s.%s = %s AND %s.flocaleid = '%s'";

    public CosmicEntity(EntityPropertyHelper helper, int offset) {
        this.helper = helper;
        this.pk = helper.getPk();
        this.offset = offset;
    }

    public CosmicEntity(EntityPropertyHelper helper) {
        this(helper, 0);
    }

    public void scan(List<String> propertyName) {
        List<CosmicProperty> propertyList = this.getProperty(propertyName);
        for (CosmicProperty cosmicProperty : propertyList) {
            if (cosmicProperty instanceof GLangCosmicProperty && this.langTableName == null) {
                this.langTableName = ((GLangCosmicProperty)cosmicProperty).getGLangTableName();
            }
            List<String> ts = cosmicProperty.getReferenceTableList();
            for (String table : ts) {
                if (this.tables.containsKey(table)) continue;
                this.tables.put(table, this.tables.size() + this.offset);
            }
        }
    }

    public String generatorColumnName(String table, String columnName) {
        Integer ordinal = this.tables.get(table);
        return TableNameHelp.createColumnName(columnName, ordinal);
    }

    public List<CosmicProperty> getProperty(List<String> propertyNameList) {
        ArrayList<CosmicProperty> propertyList = new ArrayList<CosmicProperty>(propertyNameList.size());
        for (String name : propertyNameList) {
            propertyList.add(this.getProperty(name));
        }
        return propertyList;
    }

    public CosmicProperty getProperty(String propertyName) {
        DataType dataType = this.helper.getPropertyType(propertyName);
        CosmicDataTypeEnum typeEnum = CosmicDataTypeEnum.BASIC;
        if (dataType instanceof CosmicMappingDataType) {
            typeEnum = CosmicDataTypeEnum.valueOf(dataType.id());
        }
        if (typeEnum.isBelongTo(CosmicDataTypeEnum.OneToOne)) {
            return new BasicCosmicProperty(propertyName, this.helper, this);
        }
        if (typeEnum.isBelongTo(CosmicDataTypeEnum.GLang)) {
            return new GLangCosmicProperty(typeEnum, propertyName, this.helper, this);
        }
        if (typeEnum == CosmicDataTypeEnum.MULTIPLE_BASE_DATA) {
            return new MultipleBaseDataCosmicProperty(propertyName, this.helper, this);
        }
        if (typeEnum == CosmicDataTypeEnum.PARENT_REFERENCE) {
            return new ParentReferenceCosmicProperty(propertyName, this.helper, this);
        }
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedProperty, (Object[])new Object[]{propertyName, typeEnum.name()});
    }

    public EntityPropertyHelper getHelper() {
        return this.helper;
    }

    @Override
    public CosmicProperty getProperty(int index) {
        return this.getProperty(this.helper.getColumnName(index));
    }

    @Override
    public void printFrom(SqlSegmentBuilder.ClauseBuilder builder) {
        builder.appendBlankSpace();
        HashMap<String, Integer> tables = new HashMap<String, Integer>(this.tables);
        ArrayList<String> keys = new ArrayList<String>(tables.keySet());
        String mainTableName = this.helper.getMainTableName();
        keys.sort((o1, o2) -> {
            if (o1.equalsIgnoreCase(mainTableName)) {
                return -1;
            }
            if (o2.equalsIgnoreCase(mainTableName)) {
                return 1;
            }
            return o1.compareToIgnoreCase((String)o2);
        });
        StringBuilder joinBuilder = new StringBuilder();
        String firstTable = (String)keys.get(0);
        String firstTablePrimary = TableNameHelp.createTablePrefix(tables.get(firstTable)) + '.' + this.pk.getAlias();
        String primaryColumnName = this.pk.getAlias();
        joinBuilder.append(TableNameHelp.createTableAlias(firstTable, tables.get(firstTable)));
        for (int i = 1; i < keys.size(); ++i) {
            joinBuilder.append(' ');
            String key = (String)keys.get(i);
            String tableAlias = TableNameHelp.createTableAlias(key, tables.get(key));
            if (key.equalsIgnoreCase(this.langTableName)) {
                String tablePrefix = TableNameHelp.createTablePrefix(tables.get(key));
                Context context = Contexts.get();
                joinBuilder.append(String.format(joinTemplateWithLang, tableAlias, tablePrefix, primaryColumnName, firstTablePrimary, tablePrefix, context.getConfig(SessionContextOption.LanguageEnv.key())));
                continue;
            }
            joinBuilder.append(String.format(joinTemplate, tableAlias, TableNameHelp.createTablePrefix(tables.get(key)), primaryColumnName, firstTablePrimary));
        }
        builder.append(joinBuilder.toString());
    }

    public String getRouteKey() {
        return this.helper.getRouteKey();
    }

    public void setAppendGLang(boolean appendGLang) {
        this.appendGLang = appendGLang;
    }

    public boolean isAppendGLang() {
        return this.appendGLang;
    }
}

