/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.schema.cosmic.DataEntityPropertyParser;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;

public class EntityPropertyHelper
extends DataEntityPropertyParser {
    private final DataEntityPropertyCollection properties;
    private final DataType type;
    private final List<DataTypeField> fieldList;

    public EntityPropertyHelper(String name, IDataEntityType entityType) {
        super(name, entityType);
        this.properties = entityType.getProperties();
        this.type = this.parse();
        this.fieldList = this.type.getFieldList();
        this.checkEntityType();
    }

    private void checkEntityType() {
        if (this.entityType.getAlias() == null || this.entityType.getAlias().trim().isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.EntityMissPhysicalTable, (Object[])new Object[]{this.name});
        }
    }

    public ISimpleProperty getPk() {
        return this.entityType.getPrimaryKey();
    }

    public String getColumnName(String propertyName) {
        IDataEntityProperty property = (IDataEntityProperty)this.properties.get((Object)propertyName);
        return property.getAlias();
    }

    public String getParentReferenceColumnName(String propertyName) {
        IDataEntityType parent = this.entityType.getParent();
        ISimpleProperty parentPrimaryProperty = parent.getPrimaryKey();
        return parentPrimaryProperty.getAlias();
    }

    public String getMultipleReferenceTableName(String propertyName) {
        IDataEntityProperty property = (IDataEntityProperty)this.properties.get((Object)propertyName);
        return property.getAlias();
    }

    public String getMultipleColumnName(String propertyName) {
        return ((MulBasedataProp)this.properties.get((Object)propertyName)).getRefIdProp().getAlias();
    }

    public String getColumnName(int index) {
        return this.fieldList.get(index).getName();
    }

    public String getOneToOneTableNameByPropertyName(String name) {
        String tableName = this.entityType.getAlias();
        IDataEntityProperty property = (IDataEntityProperty)this.properties.get((Object)name);
        String suffix = property.getTableGroup();
        if (suffix != null && suffix.length() > 0) {
            return tableName + '_' + suffix;
        }
        return tableName;
    }

    public String getParentReferenceTableName(String name) {
        return this.entityType.getAlias();
    }

    public DataType getPropertyType(String propertyName) {
        return this.type.getField(propertyName).getType();
    }

    public String getMainTableName() {
        return this.entityType.getAlias();
    }

    public String getRouteKey() {
        return this.entityType.getDBRouteKey();
    }
}

