/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypeEnum;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicEntity;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;

public class GLangCosmicProperty
implements CosmicProperty {
    private final boolean isGL;
    private final String columnName;
    private final String mainTable;
    private final String referenceTable;
    private final CosmicEntity entity;
    private static final String template = "(CASE WHEN %s IS NOT NULL THEN %s WHEN %s = '' THEN %s WHEN %s = '' THEN %s ELSE %s END) AS %s";

    public GLangCosmicProperty(CosmicDataTypeEnum typeEnum, String propertyName, EntityPropertyHelper helper, CosmicEntity entity) {
        this.isGL = typeEnum == CosmicDataTypeEnum.COMMON_MULTIPLE_LANGUAGE;
        this.columnName = helper.getColumnName(propertyName);
        this.mainTable = helper.getMainTableName();
        this.referenceTable = this.mainTable + "_l";
        this.entity = entity;
        this.entity.setAppendGLang(true);
    }

    @Override
    public void printInSelectListClause(SqlSegmentBuilder.ClauseBuilder builder) {
        if (this.isGL) {
            String columnInMainTable = this.entity.generatorColumnName(this.mainTable, this.columnName);
            String columnInReferenceTable = this.entity.generatorColumnName(this.referenceTable, this.columnName);
            builder.append(String.format(template, columnInReferenceTable, columnInReferenceTable, columnInMainTable, columnInReferenceTable, columnInReferenceTable, columnInMainTable, columnInMainTable, this.columnName));
        } else {
            String name = this.entity.generatorColumnName(this.referenceTable, this.columnName);
            builder.append(name);
        }
    }

    @Override
    public void printInWhereClause(SqlSegmentBuilder.ClauseBuilder builder) {
        String name = this.entity.generatorColumnName(this.referenceTable, this.columnName);
        builder.append(name);
    }

    @Override
    public List<String> getReferenceTableList() {
        if (this.isGL) {
            return Lists.newArrayList((Object[])new String[]{this.mainTable, this.referenceTable});
        }
        return Lists.newArrayList((Object[])new String[]{this.referenceTable});
    }

    public String getGLangTableName() {
        return this.referenceTable;
    }
}

