/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.rex.BaseRexNodeVisitor1;
import kd.bos.flydb.core.rex.RexCall;
import kd.bos.flydb.core.rex.RexDynamicParam;
import kd.bos.flydb.core.rex.RexInputRef;
import kd.bos.flydb.core.rex.RexLiteral;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.rex.RexNodeList;
import kd.bos.flydb.core.rex.RexRangeRef;
import kd.bos.flydb.core.rex.RexSubQuery;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.DialectSqlPrinter;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegment;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;
import kd.bos.flydb.core.schema.cosmic.translate.Translator;
import kd.bos.flydb.core.sql.tree.SqlKind;

public class KSQLDialectSqlPrinter
extends BaseRexNodeVisitor1
implements DialectSqlPrinter {
    private static final IdentityHashMap<SqlKind, DialectSqlPrinter.CallPrinter> callMapper = new IdentityHashMap();
    private final Translator translator;
    private final SqlSegmentBuilder.ClauseBuilder clauseBuilder;
    private final SqlSegmentBuilder.Clause clause;

    public KSQLDialectSqlPrinter(SqlSegmentBuilder.ClauseBuilder clauseBuilder, SqlSegmentBuilder.Clause clause, Translator translator) {
        this.translator = translator;
        this.clause = clause;
        this.clauseBuilder = clauseBuilder;
    }

    @Override
    public void appendBlankSpace() {
        this.clauseBuilder.appendBlankSpace();
    }

    @Override
    public void printKeyword(String string) {
        this.clauseBuilder.append(string);
    }

    @Override
    public void deleteLastChar() {
        this.clauseBuilder.deleteLastChar();
    }

    @Override
    public void visitRexCall(RexCall call) {
        DialectSqlPrinter.CallPrinter printer = callMapper.get((Object)call.getKind());
        if (printer == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.Unexpected1, (Object[])new Object[]{call.getDigest()});
        }
        printer.print(call, this.clauseBuilder, this);
    }

    @Override
    public void visitRexDynamicParam(RexDynamicParam dynamicParam) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public void visitRexInputRef(RexInputRef inputRef) {
        CosmicProperty cosmicProperty = this.translator.getProperty(inputRef.getIndex());
        if (this.clause == SqlSegmentBuilder.Clause.SELECT_LIST) {
            cosmicProperty.printInSelectListClause(this.clauseBuilder);
        } else if (this.clause == SqlSegmentBuilder.Clause.WHERE) {
            cosmicProperty.printInWhereClause(this.clauseBuilder);
        }
    }

    @Override
    public void visitRexLiteral(RexLiteral literal) {
        super.visitRexLiteral(literal);
        this.clauseBuilder.append("?");
        this.clauseBuilder.appendParam(KSQLDialectSqlPrinter.literalToObject(literal));
    }

    @Override
    public void visitRexNodeList(RexNodeList nodeList) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public void visitRexSubQuery(RexSubQuery subQuery) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public void visitRexRangeRef(RexRangeRef rexRangeRef) {
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    private static Object literalToObject(RexLiteral literal) {
        return literal.getValue();
    }

    static {
        callMapper.put(SqlKind.PLUS, new BinaryOperatorPrinter("+"));
        callMapper.put(SqlKind.MINUS, new BinaryOperatorPrinter("-"));
        callMapper.put(SqlKind.TIMES, new BinaryOperatorPrinter("*"));
        callMapper.put(SqlKind.MOD, new BinaryOperatorPrinter("%"));
        callMapper.put(SqlKind.DIVIDE, new BinaryOperatorPrinter("/"));
        callMapper.put(SqlKind.AND, new BinaryOperatorPrinter("AND"));
        callMapper.put(SqlKind.OR, new BinaryOperatorPrinter("OR"));
        callMapper.put(SqlKind.NOT, new NotOperatorPrinter());
        callMapper.put(SqlKind.EQUALS, new BinaryOperatorPrinter("="));
        callMapper.put(SqlKind.NOT_EQUALS, new BinaryOperatorPrinter("<>"));
        callMapper.put(SqlKind.LESS_THAN, new BinaryOperatorPrinter("<"));
        callMapper.put(SqlKind.LESS_THAN_OR_EQUALS, new BinaryOperatorPrinter("<="));
        callMapper.put(SqlKind.GREATER_THAN, new BinaryOperatorPrinter(">"));
        callMapper.put(SqlKind.GREATER_THAN_OR_EQUALS, new BinaryOperatorPrinter(">="));
        callMapper.put(SqlKind.IS_NULL, new IsNullPrinter());
        callMapper.put(SqlKind.IS_NOT_NULL, new IsNotNullPrinter());
        callMapper.put(SqlKind.IN, new InPrinter(false));
        callMapper.put(SqlKind.NOT_IN, new InPrinter(true));
        callMapper.put(SqlKind.LIKE, new BinaryOperatorPrinter("LIKE"));
        callMapper.put(SqlKind.NOT_LIKE, new BinaryOperatorPrinter("NOT LIKE"));
        callMapper.put(SqlKind.FUNC_ABS, new FunctionPrinter("abs"));
        callMapper.put(SqlKind.FUNC_MOD, new FunctionPrinter("mod"));
        callMapper.put(SqlKind.FUNC_CEIL, new FunctionPrinter("ceiling"));
        callMapper.put(SqlKind.FUNC_FLOOR, new FunctionPrinter("floor"));
        callMapper.put(SqlKind.FUNC_SIN, new FunctionPrinter("sin"));
        callMapper.put(SqlKind.FUNC_TAN, new FunctionPrinter("tan"));
        callMapper.put(SqlKind.FUNC_CONCAT, new FunctionPrinter("concat"));
        callMapper.put(SqlKind.FUNC_LENGTH, new FunctionPrinter("length"));
        callMapper.put(SqlKind.FUNC_LOWER, new FunctionPrinter("lcase"));
        callMapper.put(SqlKind.FUNC_UPPER, new FunctionPrinter("ucase"));
        callMapper.put(SqlKind.FUNC_SUBSTR, new FunctionPrinter("substring"));
    }

    private static class FunctionPrinter
    implements DialectSqlPrinter.CallPrinter {
        private final String functionName;

        public FunctionPrinter(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            builder.appendBlankSpace();
            builder.append(this.functionName);
            builder.append("(");
            if (call.getOperands() != null) {
                for (RexNode operand : call.getOperands()) {
                    operand.accept(printer);
                }
            }
            builder.append(")");
        }
    }

    private static class InPrinter
    implements DialectSqlPrinter.CallPrinter {
        private final boolean isNotIn;

        public InPrinter(boolean isNotIn) {
            this.isNotIn = isNotIn;
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            SqlSegment inSegment = builder.newSegment(true);
            call.getOperand(0).accept(printer);
            builder.appendBlankSpace();
            if (this.isNotIn) {
                builder.append("NOT IN");
            } else {
                builder.append("IN");
            }
            RexNodeList params = call.getOperand(1).cast(RexNodeList.class);
            ArrayList<Object> objectParamList = new ArrayList<Object>(params.size());
            for (RexNode param : params) {
                if (param instanceof RexLiteral) {
                    objectParamList.add(KSQLDialectSqlPrinter.literalToObject(param.cast(RexLiteral.class)));
                    continue;
                }
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
            inSegment.params.addAll(objectParamList);
            builder.newSegment(false);
        }
    }

    private static class IsNotNullPrinter
    implements DialectSqlPrinter.CallPrinter {
        private IsNotNullPrinter() {
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            printer.appendBlankSpace();
            builder.append("IS NOT NULL");
        }
    }

    private static class IsNullPrinter
    implements DialectSqlPrinter.CallPrinter {
        private IsNullPrinter() {
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            printer.appendBlankSpace();
            builder.append("IS NULL");
        }
    }

    private static class NotOperatorPrinter
    implements DialectSqlPrinter.CallPrinter {
        private NotOperatorPrinter() {
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            printer.appendBlankSpace();
            builder.append("NOT ");
            call.getOperand(0).accept(printer);
        }
    }

    private static class BinaryOperatorPrinter
    implements DialectSqlPrinter.CallPrinter {
        private final String operate;

        public BinaryOperatorPrinter(String operate) {
            this.operate = operate;
        }

        @Override
        public void print(RexCall call, SqlSegmentBuilder.ClauseBuilder builder, DialectSqlPrinter printer) {
            call.getOperand(0).accept(printer);
            printer.appendBlankSpace();
            builder.append(this.operate);
            printer.appendBlankSpace();
            call.getOperand(1).accept(printer);
        }
    }
}

