/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.flydb.core.schema.cosmic.CosmicDataTypes;
import kd.bos.flydb.core.schema.cosmic.DataEntityPropertyParser;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;

public class MetaEntityPropertyParser
extends DataEntityPropertyParser {
    private final DataEntityPropertyCollection properties;
    private final DataType type;
    private final List<DataTypeField> fieldList;

    public MetaEntityPropertyParser(String name, IDataEntityType entityType) {
        super(name, entityType);
        this.properties = entityType.getProperties();
        this.type = this.parse();
        this.fieldList = this.type.getFieldList();
    }

    @Override
    protected void wash() {
        for (IDataEntityProperty property : this.entityType.getProperties()) {
            if (property instanceof DynamicLocaleProperty) continue;
            this.propertyMap.put(property.getName(), property);
        }
        for (IDataEntityProperty property : this.entityType.getProperties()) {
            if (property instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)property;
                this.propertyMap.remove(basedataProp.getRefIdPropName());
            }
            if (property instanceof GeoPointProp) {
                this.propertyMap.remove(property.getName());
            }
            if (property instanceof SubEntryProp) continue;
            if (property instanceof EntryProp) {
                SubEntryProp subEntryProp = null;
                for (IDataEntityProperty p : ((EntryProp)property)._collectionItemPropertyType.getProperties()) {
                    if (!(p instanceof SubEntryProp)) continue;
                    subEntryProp = (SubEntryProp)p;
                }
                if (subEntryProp == null) continue;
                this.propertyMap.put(subEntryProp.getName(), subEntryProp);
                continue;
            }
            if (property.getAlias() != null && !property.getAlias().isEmpty()) continue;
            this.propertyMap.remove(property.getName());
        }
        if (this.entityType instanceof EntryType) {
            IDataEntityType parent = this.entityType.getParent();
            ISimpleProperty parentPrimaryProperty = parent.getPrimaryKey();
            this.fields.put("_pid", this.createParentReferenceType((IDataEntityProperty)parentPrimaryProperty));
        }
    }

    @Override
    protected DataType getFieldType(IDataEntityProperty property) {
        int dbType;
        if (property instanceof BasedataProp) {
            DataType dbType2 = this.dbTypeMapping(((BasedataProp)property).getDbType(), property.getName());
            return CosmicDataTypes.createBaseData(dbType2.getTypeName());
        }
        if (property instanceof MulBasedataProp) {
            DataType dbType3 = this.dbTypeMapping(((MulBasedataProp)property).getDbType(), property.getName());
            return CosmicDataTypes.createMultipleBaseData(dbType3.getTypeName());
        }
        if (property instanceof MuliLangTextProp) {
            MuliLangTextProp muliLangProperty = (MuliLangTextProp)property;
            boolean isGLang = muliLangProperty.isGL();
            return isGLang ? CosmicDataTypes.createCommonMultipleLanguage() : CosmicDataTypes.createMultipleLanguage();
        }
        if (property instanceof SubEntryProp) {
            SubEntryProp subEntryProp = (SubEntryProp)property;
            return CosmicDataTypes.createSubEntry();
        }
        if (property instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)property;
            return CosmicDataTypes.createEntry();
        }
        if (property instanceof ISimpleProperty) {
            ISimpleProperty simpleProperty = (ISimpleProperty)property;
            dbType = simpleProperty.getDbType();
        } else if (property instanceof IFieldHandle) {
            IFieldHandle fieldHandle = (IFieldHandle)property;
            dbType = fieldHandle.getDbType();
        } else {
            throw new UnsupportedOperationException("Unknown property: " + property.getName() + " type.");
        }
        return this.dbTypeMapping(dbType, property.getName());
    }

    public Map<String, IDataEntityProperty> getPropertyMap() {
        return this.propertyMap;
    }

    public DataType getType() {
        return this.type;
    }
}

