/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicEntity;
import kd.bos.flydb.core.schema.cosmic.translate.CosmicProperty;
import kd.bos.flydb.core.schema.cosmic.translate.EntityPropertyHelper;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegmentBuilder;

public class ParentReferenceCosmicProperty
implements CosmicProperty {
    private final String columnName;
    private final String referenceTable;
    private final CosmicEntity entity;

    public ParentReferenceCosmicProperty(String propertyName, EntityPropertyHelper helper, CosmicEntity entity) {
        this.columnName = helper.getParentReferenceColumnName(propertyName);
        this.referenceTable = helper.getParentReferenceTableName(propertyName);
        this.entity = entity;
    }

    @Override
    public void printInSelectListClause(SqlSegmentBuilder.ClauseBuilder builder) {
        String name = this.entity.generatorColumnName(this.referenceTable, this.columnName);
        builder.append(name);
    }

    @Override
    public void printInWhereClause(SqlSegmentBuilder.ClauseBuilder builder) {
        String name = this.entity.generatorColumnName(this.referenceTable, this.columnName);
        builder.append(name);
    }

    @Override
    public List<String> getReferenceTableList() {
        return Lists.newArrayList((Object[])new String[]{this.referenceTable});
    }
}

