/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.cosmic.translate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.schema.cosmic.translate.SqlSegment;

public class SqlSegmentBuilder
implements Serializable {
    public final ClauseBuilder selectList = new ClauseBuilder(Clause.SELECT_LIST);
    public final ClauseBuilder from = new ClauseBuilder(Clause.FROM);
    public final ClauseBuilder where = new ClauseBuilder(Clause.WHERE);

    public static class ClauseBuilder
    implements Serializable {
        private final ArrayList<SqlSegment> segments = new ArrayList();
        private Clause clause;

        public ClauseBuilder() {
        }

        public ClauseBuilder(Clause clause) {
            this.clause = clause;
        }

        public SqlSegment newSegment(boolean isIn) {
            SqlSegment segment = new SqlSegment(isIn);
            this.segments.add(segment);
            return segment;
        }

        public void append(String string) {
            this.getLast().append(string);
        }

        public void appendParam(Object param) {
            this.getLast().params.add(param);
        }

        public void appendParamList(List<Object> paramList) {
            this.getLast().params.addAll(paramList);
        }

        public void appendBlankSpace() {
            if (this.segments.isEmpty()) {
                this.segments.add(new SqlSegment(false));
            }
            SqlSegment last = this.segments.get(this.segments.size() - 1);
            if (last.append.length() == 0) {
                last.append.append(' ');
            } else if (last.append.charAt(last.append.length() - 1) != ' ') {
                last.append.append(' ');
            }
        }

        private SqlSegment getLast() {
            return this.segments.get(this.segments.size() - 1);
        }

        public void deleteLastChar() {
            this.getLast().deleteLastChar();
        }

        public ArrayList<SqlSegment> getSegments() {
            return new ArrayList<SqlSegment>(this.segments);
        }
    }

    public static enum Clause {
        SELECT_LIST,
        FROM,
        WHERE;

    }
}

