/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.Context;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.rel.TableScanTag;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.schema.FormAttribute;
import kd.bos.flydb.core.schema.Scanner;
import kd.bos.flydb.core.schema.Schema;
import kd.bos.flydb.core.schema.SchemaFactory;
import kd.bos.flydb.core.schema.SchemaFactorys;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.metadata.ColumnInfo;
import kd.bos.flydb.core.schema.metadata.SchemaInfo;
import kd.bos.flydb.core.schema.metadata.SessionInfo;
import kd.bos.flydb.core.schema.metadata.SessionInfoProvider;
import kd.bos.flydb.core.schema.metadata.TableInfo;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;
import org.jetbrains.annotations.NotNull;

public class MetadataTable
implements Table {
    private final List<String> name;
    private final DataType dataType;
    private final SqlKind sqlKind;
    private String schemaCondition;
    private Table table;
    private final String className;

    public MetadataTable(String className, List<String> name, DataType dataType, SqlKind sqlKind) {
        this.name = name;
        this.dataType = dataType;
        this.sqlKind = sqlKind;
        this.className = className;
    }

    public void setSchemaCondition(String schemaCondition) {
        this.schemaCondition = schemaCondition.toLowerCase(Locale.ENGLISH);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public List<String> getName() {
        return this.name;
    }

    @Override
    public List<String> fullyQualityName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataType getObjectRelationDataType() {
        return this.dataType;
    }

    @Override
    public Scanner createScanner(int[] project, RexNode filter) {
        Scanner scanner;
        Context context = Contexts.get();
        Long currentUserId = context.getCurrentUserId();
        String currentDatabase = context.getCurrentDatabase();
        String currentSchema = context.getCurrentSchema();
        switch (this.sqlKind) {
            case SHOW_SESSIONS: {
                scanner = new SeesionsScanner(context, this.dataType);
                break;
            }
            case SHOW_DATABASES: {
                scanner = new DatabasesScanner(currentDatabase, this.dataType);
                break;
            }
            case SHOW_SCHEMAS: {
                scanner = new SchemasScanner(this.className, this.dataType, currentUserId, currentDatabase);
                break;
            }
            case SHOW_TABLES: {
                scanner = new TablesScanner(this.className, currentSchema, this.schemaCondition, this.dataType);
                break;
            }
            case SHOW_COLUMNS: {
                scanner = new CloumnsScanner(this.table, this.dataType);
                break;
            }
            default: {
                throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedCommand, (Object[])new Object[]{this.sqlKind.getName()});
            }
        }
        return scanner;
    }

    @Override
    public List<ColumnInfo> getColumnInfos() {
        return null;
    }

    @Override
    public FormAttribute getFormAttribute() {
        return FormAttribute.dummyFormAttribute();
    }

    @Override
    public boolean isAllowTableScanTag(TableScanTag tableScanTag) {
        return false;
    }

    @Override
    public void validate() {
    }

    public static class CloumnsScanner
    implements Scanner {
        private final Table table;
        private final DataType dataType;

        public CloumnsScanner(Table table, DataType dataType) {
            this.table = table;
            this.dataType = dataType;
        }

        @Override
        public Iterable<Object[]> scan() {
            return () -> this.innerIterator(this.table.getColumnInfos().iterator());
        }

        @NotNull
        private Iterator<Object[]> innerIterator(final Iterator<ColumnInfo> iterator) {
            return new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    return ((ColumnInfo)iterator.next()).toObjectArr();
                }
            };
        }

        @Override
        public DataType getRowType() {
            return this.dataType;
        }

        @Override
        public void close() {
        }
    }

    public static class TablesScanner
    implements Scanner {
        private final String className;
        private final String currentSchema;
        private final String schemaCondition;
        private final DataType dataType;

        public TablesScanner(String className, String currentSchema, String schemaCondition, DataType dataType) {
            this.className = className;
            this.currentSchema = currentSchema;
            this.schemaCondition = schemaCondition;
            this.dataType = dataType;
        }

        @Override
        public Iterable<Object[]> scan() {
            SchemaFactory factory = SchemaFactorys.newInstance(this.className);
            Schema schemaInstance = factory.getSchema(this.currentSchema);
            List<TableInfo> tables = schemaInstance.getTableInfos(this.schemaCondition);
            return () -> this.innerIterator(tables.iterator());
        }

        @NotNull
        private Iterator<Object[]> innerIterator(final Iterator<TableInfo> iterator) {
            return new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    return ((TableInfo)iterator.next()).toObjectArr();
                }
            };
        }

        @Override
        public DataType getRowType() {
            return this.dataType;
        }

        @Override
        public void close() {
        }
    }

    public static class SchemasScanner
    implements Scanner {
        private final String className;
        private final DataType dataType;
        private final Long userId;
        private final String database;

        public SchemasScanner(String className, DataType dataType, Long userId, String database) {
            this.className = className;
            this.dataType = dataType;
            this.userId = userId;
            this.database = database;
        }

        @Override
        public Iterable<Object[]> scan() {
            return this::innerIterator;
        }

        @NotNull
        private Iterator<Object[]> innerIterator() {
            List<SchemaInfo> schemaInfos = SchemaFactorys.newInstance(this.className).listSchemas(this.userId, this.database);
            final Iterator<SchemaInfo> iterator = schemaInfos.iterator();
            return new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    return ((SchemaInfo)iterator.next()).toObjectArr();
                }
            };
        }

        @Override
        public DataType getRowType() {
            return this.dataType;
        }

        @Override
        public void close() {
        }
    }

    public static class DatabasesScanner
    implements Scanner {
        private final String database;
        private final DataType dataType;

        public DatabasesScanner(String database, DataType dataType) {
            this.database = database;
            this.dataType = dataType;
        }

        @Override
        public Iterable<Object[]> scan() {
            ArrayList<Object[]> databases = new ArrayList<Object[]>();
            databases.add(new Object[]{this.database});
            return databases;
        }

        @Override
        public DataType getRowType() {
            return this.dataType;
        }

        @Override
        public void close() {
        }
    }

    public static class SeesionsScanner
    implements Scanner {
        private static final String className = "kd.bos.flydb.server.SessionInfoProviderImpl";
        private final Context context;
        private final DataType dataType;

        public SeesionsScanner(Context context, DataType dataType) {
            this.context = context;
            this.dataType = dataType;
        }

        @Override
        public Iterable<Object[]> scan() {
            SessionInfoProvider provider;
            try {
                provider = (SessionInfoProvider)Class.forName(className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw Exceptions.of((ErrorCode)ErrorCode.ServerError_SessionInfoProviderCreateFail, (Object[])new Object[]{e.getMessage()});
            }
            List<SessionInfo> sessionInfos = provider.list();
            final Iterator<SessionInfo> iterator = sessionInfos.iterator();
            return () -> new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    return ((SessionInfo)iterator.next()).toObjectArr();
                }
            };
        }

        @Override
        public DataType getRowType() {
            return this.dataType;
        }

        @Override
        public void close() {
        }
    }
}

