/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.metadata;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Map;
import kd.bos.flydb.core.schema.metadata.ColumnInfo;
import kd.bos.flydb.core.schema.metadata.DatabaseInfo;
import kd.bos.flydb.core.schema.metadata.MetadataTable;
import kd.bos.flydb.core.schema.metadata.SchemaInfo;
import kd.bos.flydb.core.schema.metadata.SessionInfo;
import kd.bos.flydb.core.schema.metadata.TableInfo;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.validate.SqlValidateConfig;

public class MetadataTableFactory {
    private static final Map<SqlKind, DataType> MAP = new HashMap<SqlKind, DataType>();
    private static final String META_PREFIX = "$META_";

    public static MetadataTable create(SqlKind kind, SqlValidateConfig config) {
        DataType type = MAP.get((Object)kind);
        return new MetadataTable(config.getSchemaFactoryClassName(), Lists.newArrayList((Object[])new String[]{META_PREFIX + kind.name()}), type, kind);
    }

    static {
        MAP.put(SqlKind.SHOW_SESSIONS, SessionInfo.dataType());
        MAP.put(SqlKind.SHOW_DATABASES, DatabaseInfo.dataType());
        MAP.put(SqlKind.SHOW_SCHEMAS, SchemaInfo.dataType());
        MAP.put(SqlKind.SHOW_TABLES, TableInfo.dataType());
        MAP.put(SqlKind.SHOW_COLUMNS, ColumnInfo.dataType());
    }
}

