/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.schema.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.ServerConfig;
import kd.bos.flydb.common.config.ABCConfiguration;
import kd.bos.flydb.common.config.Configuration;
import kd.bos.flydb.common.config.Option;
import kd.bos.flydb.core.Contexts;
import kd.bos.flydb.core.rel.TableScanTag;
import kd.bos.flydb.core.rex.RexNode;
import kd.bos.flydb.core.schema.FormAttribute;
import kd.bos.flydb.core.schema.Scanner;
import kd.bos.flydb.core.schema.Table;
import kd.bos.flydb.core.schema.metadata.ColumnInfo;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.TupleDataType;

public class ShowVariablesTable
implements Table {
    private final boolean global;
    private List<String> name;
    private DataType dataType;

    public ShowVariablesTable(boolean global) {
        this.global = global;
        if (global) {
            this.name = Lists.newArrayList((Object[])new String[]{"$GLOBAL_VARIABLES"});
        }
        this.name = Lists.newArrayList((Object[])new String[]{"$VARIABLES"});
        ArrayList fieldNames = Lists.newArrayList((Object[])new String[]{"key", "value", "desc"});
        DataTypeFactory typeFactory = DataTypeFactory.instance;
        ArrayList fieldTypes = Lists.newArrayList((Object[])new DataType[]{typeFactory.buildString(), typeFactory.buildString(), typeFactory.buildString()});
        this.dataType = new TupleDataType("$SHOWVARIABLES", fieldNames, fieldTypes);
    }

    @Override
    public List<String> getName() {
        return this.name;
    }

    @Override
    public List<String> fullyQualityName() {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public DataType getObjectRelationDataType() {
        return null;
    }

    @Override
    public Scanner createScanner(int[] project, RexNode filter) {
        return new ShowVariablesScanner(this.dataType, this.global);
    }

    @Override
    public List<ColumnInfo> getColumnInfos() {
        return null;
    }

    @Override
    public FormAttribute getFormAttribute() {
        return FormAttribute.dummyFormAttribute();
    }

    @Override
    public boolean isAllowTableScanTag(TableScanTag tableScanTag) {
        return false;
    }

    @Override
    public void validate() {
    }

    public static class ShowVariablesScanner
    implements Scanner {
        private final DataType rowType;
        private final String sessionId;
        private final boolean global;
        private List<Object[]> data;

        public ShowVariablesScanner(DataType rowType, boolean global) {
            this.rowType = rowType;
            this.sessionId = Contexts.get().getSessionId();
            this.global = global;
        }

        @Override
        public Iterable<Object[]> scan() {
            if (this.data != null) {
                return this.data;
            }
            ABCConfiguration configuration = this.global ? new ABCConfiguration(new Configuration[]{ServerConfig.getSysConfiguration()}) : ServerConfig.getSessionABCConfiguration((String)this.sessionId);
            this.data = new ArrayList<Object[]>(ServerConfig.getShowOptions().length);
            for (Option showOption : ServerConfig.getShowOptions()) {
                this.data.add(new Object[]{showOption.key(), configuration.getAsString(showOption), showOption.desc()});
            }
            return this.data;
        }

        @Override
        public DataType getRowType() {
            return this.rowType;
        }

        @Override
        public void close() {
            this.data.clear();
        }
    }
}

