/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.dialect;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.unparse.SqlDialect;
import kd.bos.flydb.core.sql.unparse.SqlPrettyWriter;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.util.KSqlTimeLiteralHandler;

public class KSQLDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new KSQLDialect(SqlDialect.EMPTY_CONTEXT.withIdentifierQuoteString("`"));

    public KSQLDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unParseTopN(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        writer.keyword("TOP");
        writer.setNeedWhitespace(true);
        Objects.requireNonNull(fetch, "fetch");
        fetch.unParse(writer, -1, -1);
        if (offset != null) {
            writer.keyword(SqlPrettyWriter.COMMA.name());
            offset.unParse(writer, -1, -1);
            writer.setNeedWhitespace(true);
        }
    }

    @Override
    public void unParseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
    }

    @Override
    public void unParseDateTimeLiteral(SqlWriter writer, SqlLiteral literal, int leftPrec, int rightPrec) {
        DataType dataType = literal.getDataType();
        Object timeValue = literal.getValue();
        String format = literal.toString();
        switch (dataType.getTypeName()) {
            case DATE: {
                writer.literal("{D");
                if (timeValue instanceof LocalDate) {
                    format = KSqlTimeLiteralHandler.dDtf.format((LocalDate)timeValue);
                } else if (timeValue instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    format = sdf.format(timeValue);
                }
                writer.print(writer.getDialect().quoteStringLiteral(format));
                writer.literal("}");
                break;
            }
            case TIME: {
                writer.literal("{T");
                writer.setNeedWhitespace(true);
                if (timeValue instanceof LocalTime) {
                    format = KSqlTimeLiteralHandler.tDtf.format((LocalTime)timeValue);
                } else if (timeValue instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                    format = sdf.format(timeValue);
                }
                writer.print(writer.getDialect().quoteStringLiteral(format));
                writer.literal("}");
                break;
            }
            case DATETIME: {
                writer.literal("{TS");
                writer.setNeedWhitespace(true);
                if (timeValue instanceof LocalDateTime) {
                    format = KSqlTimeLiteralHandler.tsDtf.format((LocalDateTime)timeValue);
                } else if (timeValue instanceof Date) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    format = sdf.format(timeValue);
                }
                writer.print(writer.getDialect().quoteStringLiteral(format));
                writer.literal("}");
                break;
            }
            default: {
                throw Exceptions.unParse.unexpected((Enum)dataType.getTypeName());
            }
        }
    }
}

