/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlAggregateFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlCastOperator;
import kd.bos.flydb.core.sql.operator.SqlDateOpFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlExtFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlMathFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlStringFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlToCharFunctionOperator;
import kd.bos.flydb.core.sql.operator.SqlToTypeFunctionOperator;
import kd.bos.flydb.core.sql.tree.SqlKind;

public class FunctionDefinition {
    private static final Map<String, SqlOperator> map = new HashMap<String, SqlOperator>();

    public static SqlOperator lookup(String name) {
        SqlOperator operator = map.get(name = name.toUpperCase());
        if (operator == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionNotExist, (Object[])new Object[]{name});
        }
        return operator;
    }

    public static Map<String, SqlOperator> getMap() {
        return map;
    }

    static {
        map.put("AND", new SqlMathFunctionOperator("ABS", SqlKind.FUNC_ABS));
        map.put("OR", new SqlMathFunctionOperator("OR", SqlKind.FUNC_OR));
        map.put("XOR", new SqlMathFunctionOperator("XOR", SqlKind.FUNC_XOR));
        map.put("ABS", new SqlMathFunctionOperator("ABS", SqlKind.FUNC_ABS));
        map.put("MOD", new SqlMathFunctionOperator("MOD", SqlKind.FUNC_MOD));
        map.put("CBRT", new SqlMathFunctionOperator("CBRT", SqlKind.FUNC_CBRT));
        map.put("CEIL", new SqlMathFunctionOperator("CEIL", SqlKind.FUNC_CEIL));
        map.put("FLOOR", new SqlMathFunctionOperator("FLOOR", SqlKind.FUNC_FLOOR));
        map.put("ACOS", new SqlMathFunctionOperator("ACOS", SqlKind.FUNC_ACOS));
        map.put("ASIN", new SqlMathFunctionOperator("ASIN", SqlKind.FUNC_ASIN));
        map.put("ATAN", new SqlMathFunctionOperator("ATAN", SqlKind.FUNC_ATAN));
        map.put("COS", new SqlMathFunctionOperator("COS", SqlKind.FUNC_COS));
        map.put("COT", new SqlMathFunctionOperator("COT", SqlKind.FUNC_COT));
        map.put("SIN", new SqlMathFunctionOperator("SIN", SqlKind.FUNC_SIN));
        map.put("TAN", new SqlMathFunctionOperator("TAN", SqlKind.FUNC_TAN));
        map.put("SUM", new SqlAggregateFunctionOperator("SUM", SqlKind.FUNC_SUM));
        map.put("COUNT", new SqlAggregateFunctionOperator("COUNT", SqlKind.FUNC_COUNT));
        map.put("MAX", new SqlAggregateFunctionOperator("MAX", SqlKind.FUNC_MAX));
        map.put("MIN", new SqlAggregateFunctionOperator("MIN", SqlKind.FUNC_MIN));
        map.put("AVG", new SqlAggregateFunctionOperator("AVG", SqlKind.FUNC_AVG));
        map.put("DATE_ADD", new SqlDateOpFunctionOperator("DATE_ADD", SqlKind.FUNC_DATE_ADD));
        map.put("DATE_SUB", new SqlDateOpFunctionOperator("DATE_SUB", SqlKind.FUNC_DATE_SUB));
        map.put("ADD_WEEKS", new SqlDateOpFunctionOperator("ADD_WEEKS", SqlKind.FUNC_ADD_WEEKS));
        map.put("SUB_WEEKS", new SqlDateOpFunctionOperator("SUB_WEEKS", SqlKind.FUNC_SUB_WEEKS));
        map.put("ADD_MONTHS", new SqlDateOpFunctionOperator("ADD_MONTHS", SqlKind.FUNC_ADD_MONTHS));
        map.put("SUB_MONTHS", new SqlDateOpFunctionOperator("SUB_MONTHS", SqlKind.FUNC_SUB_MONTHS));
        map.put("ADD_YEARS", new SqlDateOpFunctionOperator("ADD_YEARS", SqlKind.FUNC_ADD_YEARS));
        map.put("SUB_YEARS", new SqlDateOpFunctionOperator("SUB_YEARS", SqlKind.FUNC_SUB_YEARS));
        map.put("TO_CHAR", new SqlToCharFunctionOperator("TO_CHAR", SqlKind.FUNC_TO_CHAR));
        map.put("TO_DATE", new SqlToTypeFunctionOperator("TO_DATE", SqlKind.FUNC_TO_DATE));
        map.put("TO_TIME", new SqlToTypeFunctionOperator("TO_TIME", SqlKind.FUNC_TO_TIME));
        map.put("TO_DATETIME", new SqlToTypeFunctionOperator("TO_DATETIME", SqlKind.FUNC_TO_DATETIME));
        map.put("TO_DECIMAL", new SqlToTypeFunctionOperator("TO_DECIMAL", SqlKind.FUNC_TO_DECIMAL));
        map.put("CONCAT", new SqlStringFunctionOperator("CONCAT", SqlKind.FUNC_CONCAT));
        map.put("LENGTH", new SqlStringFunctionOperator("LENGTH", SqlKind.FUNC_LENGTH));
        map.put("LOWER", new SqlStringFunctionOperator("LOWER", SqlKind.FUNC_LOWER));
        map.put("UPPER", new SqlStringFunctionOperator("UPPER", SqlKind.FUNC_UPPER));
        map.put("SUBSTR", new SqlStringFunctionOperator("SUBSTR", SqlKind.FUNC_SUBSTR));
        map.put("CAST", new SqlCastOperator());
        map.put("VERSION", new SqlExtFunctionOperator("VERSION", SqlKind.FUNC_VERSION));
        map.put("CURRENT_USER", new SqlExtFunctionOperator("CURRENT_USER", SqlKind.FUNC_CURRENT_USER));
        map.put("CURRENT_SCHEMA", new SqlExtFunctionOperator("CURRENT_SCHEMA", SqlKind.FUNC_CURRENT_SCHEMA));
    }
}

