/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.Arrays;
import java.util.List;
import kd.bos.flydb.core.sql.operator.OperandTypeInference;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public final class OperandTypeInferences {
    public static final OperandTypeInference FIRST_KNOWN = (sqlValidator, scope, sqlNode, returnType, operandTypes) -> {
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall basicCall = (SqlBasicCall)sqlNode;
            for (SqlNode node : basicCall.getOperandList()) {
                DataType type = sqlValidator.inferDataType(node, scope);
                if (type.getTypeName() == SqlTypeName.UNKNOWN) continue;
                Arrays.fill(operandTypes, type);
                return;
            }
        }
    };
    public static final OperandTypeInference LOGIC_KNOWN = (sqlValidator, scope, sqlNode, returnType, operandTypes) -> Arrays.fill(operandTypes, sqlValidator.getTypeFactory().buildBoolean());
    public static final OperandTypeInference ANY = (sqlValidator, scope, sqlNode, returnType, operandTypes) -> {
        if (sqlNode instanceof SqlBasicCall) {
            SqlBasicCall basicCall = (SqlBasicCall)sqlNode;
            List<SqlNode> sqlNodeList = basicCall.getOperandList();
            for (int i = 0; i < sqlNodeList.size(); ++i) {
                DataType type;
                operandTypes[i] = type = sqlValidator.inferDataType(sqlNodeList.get(i), scope);
            }
        }
    };
    public static final ReturnTypeInference BINARY_OPERATOR_RETURN_TYPE = new ReturnTypeInference(){

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            return sqlValidator.getTypeFactory().buildBoolean();
        }
    };
}

