/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlArithmeticOperator
extends SqlOperatorImpl {
    public SqlArithmeticOperator(String name, SqlKind sqlKind, int precedence) {
        super(name, sqlKind, precedence, true, OperandTypeInferences.FIRST_KNOWN, (ReturnTypeInference)new CastReturnTypeInference());
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.arithmeticCoercion(scope, sqlNode.cast(SqlCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlCall call = sqlNode.cast(SqlCall.class);
        for (int i = 0; i < call.getOperandList().size(); ++i) {
            DataType type;
            SqlNode operand = call.getOperand(i);
            if (operand instanceof SqlDynamicParam || (type = sqlValidator.inferDataType(operand, scope)).getCategory() == SqlTypeCategory.NUMBER) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireNumberArgumentType, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name()});
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    public static class CastReturnTypeInference
    implements ReturnTypeInference {
        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
            SqlNode leftOperand = call.getOperand(0);
            SqlNode rightOperand = call.getOperand(1);
            DataType left = leftOperand instanceof SqlDynamicParam ? DataTypeFactory.instance.getMaxPrecisionDecimal() : sqlValidator.inferDataType(call.getOperand(0), scope);
            DataType right = rightOperand instanceof SqlDynamicParam ? DataTypeFactory.instance.getMaxPrecisionDecimal() : sqlValidator.inferDataType(call.getOperand(1), scope);
            DataType returnType = sqlValidator.getTypeCoercion().higherPrecision4NumberType(left, right);
            if (returnType == null) {
                throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireReturnType, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{sqlNode.getKind().name()});
            }
            return returnType;
        }
    }
}

