/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.unparse.SqlSyntax;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlCastOperator
extends SqlOperatorImpl {
    public SqlCastOperator() {
        super("CAST", SqlKind.FUNC_CAST, 94, true, OperandTypeInferences.ANY, (ReturnTypeInference)new CastReturnTypeInference());
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionRequireArgument, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        DataType dataType = sqlValidator.inferDataType(call.getOperand(1), scope);
        if (dataType.getTypeName() != SqlTypeName.STRING) {
            throw Exceptions.of((ErrorCode)ErrorCode.CastFunctionRequireTypeLiteral, (SqlParserPosition)call.getPosition(), (Object[])new Object[0]);
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public static class CastReturnTypeInference
    implements ReturnTypeInference {
        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
            SqlLiteral typeName = call.getOperand(1).cast(SqlLiteral.class);
            return sqlValidator.getTypeFactory().buildByName((String)typeName.getValue());
        }
    }
}

