/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlComparisonOperator
extends SqlOperatorImpl {
    public SqlComparisonOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, 30, true, OperandTypeInferences.FIRST_KNOWN, OperandTypeInferences.BINARY_OPERATOR_RETURN_TYPE);
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.binaryComparisonCoercion(scope, sqlNode.cast(SqlBasicCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        DataType dataType = sqlValidator.inferDataType(call.getOperand(0), scope);
        if (!dataType.getCategory().isBelongTo(SqlTypeCategory.COMPARISON)) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedOperatorOperandType, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), dataType.id()});
        }
        boolean checked = this.isSameCategoryOperandType(sqlValidator, scope, call);
        if (!checked) {
            DataType left = sqlValidator.inferDataType(call.getOperand(0), scope);
            DataType right = sqlValidator.inferDataType(call.getOperand(1), scope);
            throw Exceptions.of((ErrorCode)ErrorCode.ComparisonError, (Object[])new Object[]{left.id(), this.name(), right.id()});
        }
    }
}

