/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlFunctionOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.unparse.SqlSyntax;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlExtFunctionOperator
extends SqlFunctionOperatorImpl {
    public SqlExtFunctionOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, null, new SqlExtFunctionReturnTypeInference());
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall basicCall = sqlNode.cast(SqlBasicCall.class);
        if (!basicCall.getOperandList().isEmpty()) {
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionNotExist1, (Object[])new Object[]{this.name()});
        }
    }

    @Override
    public SqlSyntax getSyntax() {
        return super.getSyntax();
    }

    private static class SqlExtFunctionReturnTypeInference
    implements ReturnTypeInference {
        private SqlExtFunctionReturnTypeInference() {
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            return scope.getSqlValidator().getTypeFactory().buildString();
        }
    }
}

