/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.type.TupleDataType;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlInListOperator
extends SqlOperatorImpl {
    public SqlInListOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, 32, true, OperandTypeInferences.FIRST_KNOWN, OperandTypeInferences.BINARY_OPERATOR_RETURN_TYPE);
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{"IN", 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.inListCoercion(scope, sqlNode.cast(SqlBasicCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall basicCall = sqlNode.cast(SqlBasicCall.class);
        DataType targetType = sqlValidator.inferDataType(basicCall.getOperand(0), scope);
        SqlNode operand = basicCall.getOperand(1);
        if (operand instanceof SqlNodeList) {
            SqlNodeList nodeList = operand.cast(SqlNodeList.class);
            for (int i = 0; i < nodeList.size(); ++i) {
                SqlNode node = nodeList.get(i);
                DataType dataType = scope.getSqlValidator().inferDataType(node, scope);
                if (dataType == null) {
                    throw Exceptions.of((ErrorCode)ErrorCode.InOperatorInferDataTypeError, (Object[])new Object[0]);
                }
                if (dataType.getCategory() == targetType.getCategory()) continue;
                throw Exceptions.of((ErrorCode)ErrorCode.InOperatorRequireSameDataType, (Object[])new Object[0]);
            }
        } else {
            DataType dataType = sqlValidator.inferDataType(operand, scope);
            if (dataType instanceof TupleDataType) {
                List<DataTypeField> fieldList = dataType.getFieldList();
                if (fieldList.size() != 1) {
                    throw Exceptions.of((ErrorCode)ErrorCode.InOperatorRequireScalarSubQuery, (SqlParserPosition)operand.getPosition(), (Object[])new Object[0]);
                }
                DataTypeField dataTypeField = fieldList.get(0);
                DataType type = dataTypeField.getType();
                if (type != null && type.getCategory() != targetType.getCategory()) {
                    throw Exceptions.of((ErrorCode)ErrorCode.InOperatorRequireSameDataType, (Object[])new Object[0]);
                }
            }
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }
}

