/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlConditionType;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlJoinType;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public class SqlJoinOperator
extends SqlOperatorImpl {
    private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("USING");

    public SqlJoinOperator() {
        super("JOIN", SqlKind.JOIN, 16, true);
    }

    @Override
    public void unParse(SqlWriter writer, SqlCall sqlCall, int leftPrecedence, int rightPrecedence) {
        SqlJoin join = sqlCall.cast(SqlJoin.class);
        join.getLeft().unParse(writer, leftPrecedence, this.getLeftPrecedence());
        boolean joinNatural = false;
        if (SqlConditionType.NATURAL.name().equals(join.getConditionType().getValue())) {
            joinNatural = true;
        }
        if (SqlJoinType.CROSS.name().equals(join.getJoinType().getValue())) {
            writer.sep(joinNatural ? "NATURAL CROSS JOIN" : "CROSS JOIN");
        } else if (SqlJoinType.FULL.name().equals(join.getJoinType().getValue())) {
            writer.sep(joinNatural ? "NATURAL FULL JOIN" : "FULL JOIN");
        } else if (SqlJoinType.INNER.name().equals(join.getJoinType().getValue())) {
            writer.sep(joinNatural ? "NATURAL INNER JOIN" : "INNER JOIN");
        } else if (SqlJoinType.LEFT.name().equals(join.getJoinType().getValue())) {
            writer.sep(joinNatural ? "NATURAL LEFT JOIN" : "LEFT JOIN");
        } else if (SqlJoinType.RIGHT.name().equals(join.getJoinType().getValue())) {
            writer.sep(joinNatural ? "NATURAL RIGHT JOIN" : "RIGHT JOIN");
        } else {
            throw Exceptions.unParse.unexpected((Enum)SqlJoinType.valueOf(join.getJoinType().getValue().toString()));
        }
        join.getRight().unParse(writer, this.getRightPrecedence(), rightPrecedence);
        SqlNode joinCondition = join.getCondition();
        if (joinCondition != null) {
            if (SqlConditionType.USING.name().equals(join.getConditionType().getValue())) {
                writer.keyword("USING");
                assert (joinCondition instanceof SqlNodeList) : "joinCondition should be SqlNodeList, got " + joinCondition;
                SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
                joinCondition.unParse(writer, 0, 0);
                writer.endList(frame);
            } else if (SqlConditionType.ON.name().equals(join.getConditionType().getValue())) {
                writer.keyword("ON");
                joinCondition.unParse(writer, leftPrecedence, rightPrecedence);
            } else {
                throw Exceptions.unParse.unexpected((Enum)SqlJoinType.valueOf(join.getConditionType().getValue().toString()));
            }
        }
    }
}

