/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlLikeOperator
extends SqlOperatorImpl {
    public SqlLikeOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, 32, false, OperandTypeInferences.FIRST_KNOWN, OperandTypeInferences.BINARY_OPERATOR_RETURN_TYPE);
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.likeCoercion(scope, sqlNode.cast(SqlBasicCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlCall call = sqlNode.cast(SqlCall.class);
        for (int i = 0; i < call.getOperandList().size(); ++i) {
            DataType type = sqlValidator.inferDataType(call.getOperand(i), scope);
            if (type == null || type.getCategory() == SqlTypeCategory.STRING) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireStringArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }
}

