/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.Arrays;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInference;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlFunctionOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlMathFunctionOperator
extends SqlFunctionOperatorImpl {
    public SqlMathFunctionOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, new MathFunctionOperandTypeInference(), new MathFunctionReturnTypeInference(sqlKind));
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() <= 0 || call.getOperandCount() > 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument1, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 1, 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.mathFunctionCoercion(scope, sqlNode.cast(SqlCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlCall call = sqlNode.cast(SqlCall.class);
        for (int i = 0; i < call.getOperandList().size(); ++i) {
            DataType type = sqlValidator.inferDataType(call.getOperand(i), scope);
            if (type.getCategory() == SqlTypeCategory.NUMBER) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireNumberArgumentType, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    private static class MathFunctionReturnTypeInference
    implements ReturnTypeInference {
        private final SqlKind sqlKind;

        public MathFunctionReturnTypeInference(SqlKind sqlKind) {
            this.sqlKind = sqlKind;
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            if (this.sqlKind == SqlKind.FUNC_ABS) {
                SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
                return sqlValidator.inferDataType(call.getOperand(0), scope);
            }
            if (this.sqlKind == SqlKind.FUNC_MOD) {
                SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
                SqlNode leftOperand = call.getOperand(0);
                SqlNode rightOperand = call.getOperand(1);
                DataType left = leftOperand instanceof SqlDynamicParam ? DataTypeFactory.instance.getMaxPrecisionDecimal() : sqlValidator.inferDataType(call.getOperand(0), scope);
                DataType right = rightOperand instanceof SqlDynamicParam ? DataTypeFactory.instance.getMaxPrecisionDecimal() : sqlValidator.inferDataType(call.getOperand(1), scope);
                return sqlValidator.getTypeCoercion().higherPrecision4NumberType(left, right);
            }
            return DataTypeFactory.instance.getMaxPrecisionDecimal();
        }
    }

    private static class MathFunctionOperandTypeInference
    implements OperandTypeInference {
        private MathFunctionOperandTypeInference() {
        }

        @Override
        public void inferOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode, DataType returnType, DataType[] operandTypes) {
            if (sqlNode instanceof SqlBasicCall) {
                SqlBasicCall basicCall = (SqlBasicCall)sqlNode;
                for (SqlNode node : basicCall.getOperandList()) {
                    if (node instanceof SqlDynamicParam) {
                        Arrays.fill(operandTypes, DataTypeFactory.instance.getMaxPrecisionDecimal());
                        return;
                    }
                    DataType type = sqlValidator.inferDataType(node, scope);
                    if (type.getTypeName() == SqlTypeName.UNKNOWN) continue;
                    Arrays.fill(operandTypes, type);
                    return;
                }
            }
        }
    }
}

