/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.core.sql.operator.OperandTypeInference;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.unparse.SqlSyntax;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlOperatorImpl
implements SqlOperator {
    private final String name;
    private final SqlKind sqlKind;
    private final int leftPrecedence;
    private final int rightPrecedence;
    protected OperandTypeInference operandTypeInference;
    protected ReturnTypeInference returnTypeInference;

    public SqlOperatorImpl(String name, SqlKind sqlKind, int precedence, boolean leftAssociativity) {
        this.name = name;
        this.sqlKind = sqlKind;
        this.leftPrecedence = this.leftPrecedence(precedence, leftAssociativity);
        this.rightPrecedence = this.rightPrecedence(precedence, leftAssociativity);
    }

    public SqlOperatorImpl(String name, SqlKind sqlKind, int precedence, boolean leftAssociativity, OperandTypeInference operandTypeInference, ReturnTypeInference returnTypeInference) {
        this.name = name;
        this.sqlKind = sqlKind;
        this.operandTypeInference = operandTypeInference;
        this.returnTypeInference = returnTypeInference;
        this.leftPrecedence = this.leftPrecedence(precedence, leftAssociativity);
        this.rightPrecedence = this.rightPrecedence(precedence, leftAssociativity);
    }

    public SqlOperatorImpl(String name, SqlKind sqlKind, int leftPrecedence, int rightPrecedence, OperandTypeInference operandTypeInference, ReturnTypeInference returnTypeInference) {
        this.name = name;
        this.sqlKind = sqlKind;
        this.operandTypeInference = operandTypeInference;
        this.returnTypeInference = returnTypeInference;
        this.leftPrecedence = leftPrecedence;
        this.rightPrecedence = rightPrecedence;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SqlKind getKind() {
        return this.sqlKind;
    }

    @Override
    public OperandTypeInference getOperandTypeInference() {
        return this.operandTypeInference;
    }

    @Override
    public ReturnTypeInference getReturnTypeInference() {
        return this.returnTypeInference;
    }

    @Override
    public final DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        for (SqlNode node : call.getOperandList()) {
            sqlValidator.inferDataType(node, scope);
        }
        this.checkOperandCount(sqlValidator, scope, sqlNode);
        this.operandTypeCoercion(sqlValidator, scope, sqlNode);
        this.checkOperandType(sqlValidator, scope, sqlNode);
        DataType returnType = DataTypeFactory.instance.buildUnknownType();
        ReturnTypeInference returnTypeInference = this.getReturnTypeInference();
        if (returnTypeInference != null) {
            returnType = returnTypeInference.inferReturnType(sqlValidator, scope, sqlNode);
            sqlValidator.setValidateNodeType(sqlNode, returnType);
        }
        return returnType;
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
    }

    protected final boolean isSameOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlCall call = sqlNode.cast(SqlCall.class);
        DataType type = sqlValidator.inferDataType(call.getOperand(0), scope);
        for (int i = 1; i < call.getOperandList().size(); ++i) {
            DataType otherType = sqlValidator.inferDataType(call.getOperand(i), scope);
            if (type.equals(otherType)) continue;
            return false;
        }
        return true;
    }

    protected final boolean isSameCategoryOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlCall call = sqlNode.cast(SqlCall.class);
        DataType type = sqlValidator.inferDataType(call.getOperand(0), scope);
        for (int i = 1; i < call.getOperandList().size(); ++i) {
            DataType otherType = sqlValidator.inferDataType(call.getOperand(i), scope);
            if (type.getCategory() == otherType.getCategory()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getLeftPrecedence() {
        return this.leftPrecedence;
    }

    @Override
    public int getRightPrecedence() {
        return this.rightPrecedence;
    }

    @Override
    public SqlSyntax getSyntax() {
        switch (this.getKind()) {
            case ASCENDING: 
            case DESCENDING: {
                return SqlSyntax.POSTFIX;
            }
        }
        return SqlSyntax.BINARY;
    }

    public String toString() {
        return this.name;
    }
}

