/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.IdentityHashMap;
import java.util.Map;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.FunctionDefinition;
import kd.bos.flydb.core.sql.operator.SqlArithmeticOperator;
import kd.bos.flydb.core.sql.operator.SqlAsOperator;
import kd.bos.flydb.core.sql.operator.SqlCaseOperator;
import kd.bos.flydb.core.sql.operator.SqlCastOperator;
import kd.bos.flydb.core.sql.operator.SqlComparisonOperator;
import kd.bos.flydb.core.sql.operator.SqlInListOperator;
import kd.bos.flydb.core.sql.operator.SqlIsNullOrNotOperator;
import kd.bos.flydb.core.sql.operator.SqlJoinOperator;
import kd.bos.flydb.core.sql.operator.SqlLikeOperator;
import kd.bos.flydb.core.sql.operator.SqlLogicOperator;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.operator.SqlOrderByOperator;
import kd.bos.flydb.core.sql.operator.SqlSelectOperator;
import kd.bos.flydb.core.sql.operator.SqlSetVariableOperator;
import kd.bos.flydb.core.sql.operator.SqlShowOperator;
import kd.bos.flydb.core.sql.operator.SqlShowVariablesOperator;
import kd.bos.flydb.core.sql.operator.UnresolvedFunctionOperator;
import kd.bos.flydb.core.sql.tree.SqlKind;

public class SqlOperators {
    private static Map<SqlKind, SqlOperator> operatorMap = new IdentityHashMap<SqlKind, SqlOperator>();

    public static SqlOperator of(SqlKind sqlKind) {
        SqlOperator operator = operatorMap.get((Object)sqlKind);
        if (operator == null) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedOperator1, (Object[])new Object[]{sqlKind.name()});
        }
        return operator;
    }

    public static SqlOperator unresolvedFunc(String operatorName) {
        return new UnresolvedFunctionOperator(operatorName);
    }

    public static SqlOperator func(String funcName) {
        return FunctionDefinition.lookup(funcName);
    }

    public static Map<SqlKind, SqlOperator> getOperatorMap() {
        return operatorMap;
    }

    static {
        operatorMap.put(SqlKind.SELECT, new SqlSelectOperator());
        operatorMap.put(SqlKind.ORDER_BY, new SqlOrderByOperator());
        operatorMap.put(SqlKind.JOIN, new SqlJoinOperator());
        operatorMap.put(SqlKind.CASE, new SqlCaseOperator());
        operatorMap.put(SqlKind.PLUS, new SqlArithmeticOperator(SqlKind.PLUS.getName(), SqlKind.PLUS, 40));
        operatorMap.put(SqlKind.MINUS, new SqlArithmeticOperator(SqlKind.MINUS.getName(), SqlKind.MINUS, 40));
        operatorMap.put(SqlKind.TIMES, new SqlArithmeticOperator(SqlKind.TIMES.getName(), SqlKind.TIMES, 60));
        operatorMap.put(SqlKind.DIVIDE, new SqlArithmeticOperator(SqlKind.DIVIDE.getName(), SqlKind.DIVIDE, 60));
        operatorMap.put(SqlKind.MOD, new SqlArithmeticOperator(SqlKind.MOD.getName(), SqlKind.MOD, 60));
        operatorMap.put(SqlKind.EQUALS, new SqlComparisonOperator(SqlKind.EQUALS.getName(), SqlKind.EQUALS));
        operatorMap.put(SqlKind.NOT_EQUALS, new SqlComparisonOperator(SqlKind.NOT_EQUALS.getName(), SqlKind.NOT_EQUALS));
        operatorMap.put(SqlKind.LESS_THAN, new SqlComparisonOperator(SqlKind.LESS_THAN.getName(), SqlKind.LESS_THAN));
        operatorMap.put(SqlKind.LESS_THAN_OR_EQUALS, new SqlComparisonOperator(SqlKind.LESS_THAN_OR_EQUALS.getName(), SqlKind.LESS_THAN_OR_EQUALS));
        operatorMap.put(SqlKind.GREATER_THAN, new SqlComparisonOperator(SqlKind.GREATER_THAN.getName(), SqlKind.GREATER_THAN));
        operatorMap.put(SqlKind.GREATER_THAN_OR_EQUALS, new SqlComparisonOperator(SqlKind.GREATER_THAN_OR_EQUALS.getName(), SqlKind.GREATER_THAN_OR_EQUALS));
        operatorMap.put(SqlKind.AND, new SqlLogicOperator(SqlKind.AND.getName(), SqlKind.AND, 24));
        operatorMap.put(SqlKind.OR, new SqlLogicOperator(SqlKind.OR.getName(), SqlKind.OR, 22));
        operatorMap.put(SqlKind.NOT, new SqlLogicOperator(SqlKind.NOT.getName(), SqlKind.NOT, 26));
        operatorMap.put(SqlKind.AS, new SqlAsOperator());
        operatorMap.put(SqlKind.LIKE, new SqlLikeOperator(SqlKind.LIKE.getName(), SqlKind.LIKE));
        operatorMap.put(SqlKind.NOT_LIKE, new SqlLikeOperator(SqlKind.NOT_LIKE.getName(), SqlKind.NOT_LIKE));
        operatorMap.put(SqlKind.IS_NULL, new SqlIsNullOrNotOperator(SqlKind.IS_NULL.getName(), SqlKind.IS_NULL));
        operatorMap.put(SqlKind.IS_NOT_NULL, new SqlIsNullOrNotOperator(SqlKind.IS_NOT_NULL.getName(), SqlKind.IS_NOT_NULL));
        operatorMap.put(SqlKind.IN, new SqlInListOperator(SqlKind.IN.getName(), SqlKind.IN));
        operatorMap.put(SqlKind.NOT_IN, new SqlInListOperator(SqlKind.NOT_IN.getName(), SqlKind.NOT_IN));
        operatorMap.put(SqlKind.SHOW_SESSIONS, new SqlShowOperator(SqlKind.SHOW_SESSIONS.getName(), SqlKind.SHOW_SESSIONS));
        operatorMap.put(SqlKind.SHOW_DATABASES, new SqlShowOperator(SqlKind.SHOW_DATABASES.getName(), SqlKind.SHOW_DATABASES));
        operatorMap.put(SqlKind.SHOW_SCHEMAS, new SqlShowOperator(SqlKind.SHOW_SCHEMAS.getName(), SqlKind.SHOW_SCHEMAS));
        operatorMap.put(SqlKind.SHOW_TABLES, new SqlShowOperator(SqlKind.SHOW_TABLES.getName(), SqlKind.SHOW_TABLES));
        operatorMap.put(SqlKind.SHOW_COLUMNS, new SqlShowOperator(SqlKind.SHOW_COLUMNS.getName(), SqlKind.SHOW_COLUMNS));
        operatorMap.put(SqlKind.FUNC_CAST, new SqlCastOperator());
        operatorMap.put(SqlKind.ASCENDING, new SqlOperatorImpl(SqlKind.ASCENDING.getName(), SqlKind.ASCENDING, 20, true));
        operatorMap.put(SqlKind.DESCENDING, new SqlOperatorImpl(SqlKind.DESCENDING.getName(), SqlKind.DESCENDING, 20, true));
        operatorMap.put(SqlKind.USE, new SqlOperatorImpl(SqlKind.USE.getName(), SqlKind.USE, 20, true));
        operatorMap.put(SqlKind.SHOW_VARIABLES, new SqlShowVariablesOperator());
        operatorMap.put(SqlKind.SET_SESSION_VARIABLE, new SqlSetVariableOperator());
    }
}

