/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.ArrayList;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public class SqlSelectOperator
extends SqlOperatorImpl {
    public SqlSelectOperator() {
        super("SELECT", SqlKind.SELECT, 2, true);
    }

    @Override
    public void unParse(SqlWriter writer, SqlCall sqlCall, int leftPrecedence, int rightPrecedence) {
        SqlNode where;
        SqlSelect select = sqlCall.cast(SqlSelect.class);
        SqlWriter.Frame selectFrame = writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("SELECT");
        if (select.getHints() != null && select.getHints().size() > 0) {
            writer.sep("/*+");
            select.getHints().unParse(writer, 0, 0);
            writer.print("*/");
            writer.newlineAndIndent();
        }
        for (int i = 0; select.getKeywordList() != null && i < select.getKeywordList().size(); ++i) {
            SqlNode keyword = select.getKeywordList().get(i);
            keyword.unParse(writer, 0, 0);
        }
        writer.topN(select.getLimit(), select.getOffset());
        SqlNodeList selectClause = select.getSelectList();
        writer.list(SqlWriter.FrameTypeEnum.SELECT_LIST, SqlWriter.COMMA, selectClause);
        if (select.getFrom() != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            select.getFrom().unParse(writer, SqlOperators.of(SqlKind.JOIN).getLeftPrecedence() - 1, SqlOperators.of(SqlKind.JOIN).getRightPrecedence() - 1);
            writer.endList(fromFrame);
        }
        if ((where = select.getWhere()) != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = where;
                SqlOperator whereSep = SqlOperators.of(SqlKind.AND);
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSep = SqlOperators.of(SqlKind.OR);
                }
                ArrayList<SqlNode> list = new ArrayList<SqlNode>(0);
                while (node.getKind() == whereSep.getKind()) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.getOperand(1));
                    node = call1.getOperand(0);
                }
                list.add(0, node);
                writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, whereSep, new SqlNodeList(where.getPosition(), list));
            } else {
                where.unParse(writer, 0, 0);
            }
        }
        if (select.getGroupBy() != null && select.getGroupBy().size() > 0) {
            writer.sep("GROUP BY");
            SqlNodeList groupBy = select.getGroupBy();
            writer.list(SqlWriter.FrameTypeEnum.GROUP_BY_LIST, SqlWriter.COMMA, groupBy);
        }
        if (select.getHaving() != null) {
            writer.sep("HAVING");
            select.getHaving().unParse(writer, 0, 0);
        }
        if (select.getWindowDecls() != null && select.getWindowDecls().size() > 0) {
            writer.sep("WINDOW");
            writer.list(SqlWriter.FrameTypeEnum.WINDOW_DECL_LIST, SqlWriter.COMMA, select.getWindowDecls());
        }
        if (select.getOrderBy() != null && select.getOrderBy().size() > 0) {
            writer.sep("ORDER BY");
            writer.list(SqlWriter.FrameTypeEnum.ORDER_BY_LIST, SqlWriter.COMMA, select.getOrderBy());
        }
        if (select.getOffset() != null || select.getLimit() != null) {
            writer.fetchOffset(select.getLimit(), select.getOffset());
        }
        writer.endList(selectFrame);
    }
}

