/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.AbstractList;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlBinaryOperator;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeField;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorNamespace;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlSetOperator
extends SqlBinaryOperator {
    private final boolean all;

    public SqlSetOperator(String name, SqlKind sqlKind, boolean all) {
        super(name, sqlKind, OperandTypeInferences.FIRST_KNOWN, new SetOpReturnTypeInference());
        this.all = all;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isDistinct() {
        return !this.all;
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.SetOpsAreBinary, (SqlParserPosition)call.getPosition(), (Object[])new Object[0]);
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        int i;
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        final DataType[] argTypes = new DataType[call.getOperandCount()];
        int colCount = 0;
        for (i = 0; i < argTypes.length; ++i) {
            DataType dataType;
            argTypes[i] = dataType = this.getOperandType(sqlValidator, call, i);
            if (!dataType.isStruct()) {
                throw new AssertionError((Object)"setop arg must be a struct");
            }
            List<DataTypeField> fields = dataType.getFieldList();
            if (colCount == 0) {
                colCount = fields.size();
                continue;
            }
            if (fields.size() == colCount) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.ColumnCountMismatchInSetop, (Object[])new Object[0]);
        }
        i = 0;
        while (i < colCount) {
            int i2;
            AbstractList<DataType> columnIthTypes;
            if (((DataType)(columnIthTypes = new AbstractList<DataType>(i2 = i++){
                final /* synthetic */ int val$i2;
                {
                    this.val$i2 = n;
                }

                @Override
                public DataType get(int index) {
                    return argTypes[index].getFieldList().get(this.val$i2).getType();
                }

                @Override
                public int size() {
                    return argTypes.length;
                }
            }).get(0)).equals(columnIthTypes.get(1))) continue;
            throw Exceptions.of((ErrorCode)ErrorCode.ColumnTypeMismatchInSetop, (Object[])new Object[]{columnIthTypes.get(0), columnIthTypes.get(1)});
        }
        sqlValidator.getNamespace(sqlNode).setDataType(argTypes[0]);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    private DataType getOperandType(SqlValidator sqlValidator, SqlCall call, int i) {
        SqlNode operand = call.getOperand(i);
        SqlValidatorNamespace namespace = sqlValidator.getNamespace(operand);
        return namespace.getDataType();
    }

    @Override
    public String toString() {
        return this.name();
    }

    public static class SetOpReturnTypeInference
    implements ReturnTypeInference {
        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            return sqlValidator.getNamespace(sqlNode).getDataType();
        }
    }
}

