/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.ArrayList;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public class SqlShowOperator
extends SqlOperatorImpl {
    public SqlShowOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, 100, true);
    }

    @Override
    public void unParse(SqlWriter writer, SqlCall sqlCall, int leftPrecedence, int rightPrecedence) {
        SqlNode where;
        SqlShow sqlShow = sqlCall.cast(SqlShow.class);
        SqlWriter.Frame showFrame = writer.startList(SqlWriter.FrameTypeEnum.SHOW);
        writer.keyword(this.name());
        SqlNode from = sqlShow.getOperand(0);
        if (from != null) {
            writer.sep("FROM");
            SqlWriter.Frame fromFrame = writer.startList(SqlWriter.FrameTypeEnum.FROM_LIST);
            from.unParse(writer, SqlOperators.of(SqlKind.JOIN).getLeftPrecedence() - 1, SqlOperators.of(SqlKind.JOIN).getRightPrecedence() - 1);
            writer.endList(fromFrame);
        }
        if ((where = sqlShow.getOperand(1)) != null) {
            writer.sep("WHERE");
            if (!writer.isAlwaysUseParentheses()) {
                SqlNode node = where;
                SqlOperator whereSep = SqlOperators.of(SqlKind.AND);
                if (node instanceof SqlCall && node.getKind() == SqlKind.OR) {
                    whereSep = SqlOperators.of(SqlKind.OR);
                }
                ArrayList<SqlNode> list = new ArrayList<SqlNode>(0);
                while (node.getKind() == whereSep.getKind()) {
                    assert (node instanceof SqlCall);
                    SqlCall call1 = (SqlCall)node;
                    list.add(0, call1.getOperand(1));
                    node = call1.getOperand(0);
                }
                list.add(0, node);
                writer.list(SqlWriter.FrameTypeEnum.WHERE_LIST, whereSep, new SqlNodeList(where.getPosition(), list));
            } else {
                where.unParse(writer, 0, 0);
            }
        }
        writer.endList(showFrame);
    }
}

