/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlFunctionOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.TypeCoercion;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlStringFunctionOperator
extends SqlFunctionOperatorImpl {
    public SqlStringFunctionOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, OperandTypeInferences.FIRST_KNOWN, new StringFunctionReturnTypeInference(sqlKind));
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        int operandCount = call.getOperandCount();
        if (this.getKind() == SqlKind.FUNC_CONCAT) {
            if (operandCount <= 1) {
                throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument2, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name(), 2});
            }
        } else if (this.getKind() == SqlKind.FUNC_SUBSTR) {
            if (operandCount != 3) {
                throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name(), 3});
            }
        } else if (operandCount != 1) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{this.name(), 1});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void operandTypeCoercion(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        TypeCoercion typeCoercion = sqlValidator.getTypeCoercion();
        typeCoercion.stringFuncCoercion(scope, sqlNode.cast(SqlBasicCall.class));
        super.operandTypeCoercion(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        if (this.getKind().isBelong(SqlKind.STRING_FUNC_KINDS)) {
            List<SqlNode> operandList = sqlNode.cast(SqlBasicCall.class).getOperandList();
            for (int i = 0; i < operandList.size(); ++i) {
                SqlNode operandNode = operandList.get(i);
                DataType dataType = sqlValidator.inferDataType(operandNode, scope);
                if (i != 0 && this.getKind() == SqlKind.FUNC_SUBSTR) {
                    if (dataType.getCategory() == SqlTypeCategory.NUMBER) continue;
                    throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireNumberArgumentType, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
                }
                if (dataType.getCategory() == SqlTypeCategory.STRING) continue;
                throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireStringArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
            }
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    private static class StringFunctionReturnTypeInference
    implements ReturnTypeInference {
        private final SqlKind sqlKind;

        public StringFunctionReturnTypeInference(SqlKind sqlKind) {
            this.sqlKind = sqlKind;
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            if (this.sqlKind == SqlKind.FUNC_LENGTH) {
                return sqlValidator.getTypeFactory().buildInt();
            }
            return sqlValidator.getTypeFactory().buildString();
        }
    }
}

