/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlFunctionOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlToCharFunctionOperator
extends SqlFunctionOperatorImpl {
    public SqlToCharFunctionOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, OperandTypeInferences.FIRST_KNOWN, new ToCharFunctionReturnTypeInference());
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        SqlNode left = call.getOperand(0);
        DataType leftType = sqlValidator.inferDataType(left, scope);
        if (leftType != null && leftType.getCategory() != SqlTypeCategory.DATE) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireDateArgument, (SqlParserPosition)call.getOperand(0).getPosition(), (Object[])new Object[]{this.name()});
        }
        SqlNode right = call.getOperand(1);
        DataType rightType = sqlValidator.inferDataType(right, scope);
        if (rightType != null && rightType.getCategory() != SqlTypeCategory.STRING && !(right instanceof SqlLiteral)) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireBoolArgument, (SqlParserPosition)call.getOperand(0).getPosition(), (Object[])new Object[]{this.name()});
        }
        assert (leftType != null);
        if (!this.isValidFormat(leftType, (String)((SqlLiteral)right).getValue())) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireSpecialArgument, (SqlParserPosition)call.getOperand(0).getPosition(), (Object[])new Object[]{this.name()});
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    private boolean isValidFormat(DataType type, String pattern) {
        if (type.getTypeName() == SqlTypeName.DATE) {
            return true;
        }
        return type.getTypeName() == SqlTypeName.DATETIME;
    }

    private static class ToCharFunctionReturnTypeInference
    implements ReturnTypeInference {
        private ToCharFunctionReturnTypeInference() {
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            DataTypeFactory typeFactory = sqlValidator.getTypeFactory();
            return typeFactory.buildString();
        }
    }
}

