/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.OperandTypeInferences;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlFunctionOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeCategory;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlToTypeFunctionOperator
extends SqlFunctionOperatorImpl {
    public SqlToTypeFunctionOperator(String name, SqlKind sqlKind) {
        super(name, sqlKind, OperandTypeInferences.FIRST_KNOWN, new ToTypeFunctionReturnTypeInference(sqlKind));
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 1) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 1});
        }
        super.checkOperandCount(sqlValidator, scope, sqlNode);
    }

    @Override
    public void checkOperandType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getKind().isBelong(SqlKind.TO_TYPE_CAST_KINDS)) {
            switch (call.getKind()) {
                case FUNC_TO_DATE: 
                case FUNC_TO_DATETIME: 
                case FUNC_TO_TIME: {
                    for (int i = 0; i < call.getOperandList().size(); ++i) {
                        DataType type = sqlValidator.inferDataType(call.getOperand(i), scope);
                        if (type.getCategory() == SqlTypeCategory.STRING) continue;
                        throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireStringArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
                    }
                    break;
                }
                case FUNC_TO_DECIMAL: {
                    for (int i = 0; i < call.getOperandList().size(); ++i) {
                        DataType type = sqlValidator.inferDataType(call.getOperand(i), scope);
                        if (type.getCategory() != SqlTypeCategory.DATE) continue;
                        throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireDateArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name()});
                    }
                    break;
                }
            }
        }
        super.checkOperandType(sqlValidator, scope, sqlNode);
    }

    private static class ToTypeFunctionReturnTypeInference
    implements ReturnTypeInference {
        private final SqlKind sqlKind;

        public ToTypeFunctionReturnTypeInference(SqlKind sqlKind) {
            this.sqlKind = sqlKind;
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            DataTypeFactory typeFactory = sqlValidator.getTypeFactory();
            switch (this.sqlKind) {
                case FUNC_TO_CHAR: {
                    return typeFactory.buildString();
                }
                case FUNC_TO_DATE: {
                    return typeFactory.buildDate();
                }
                case FUNC_TO_TIME: {
                    return typeFactory.buildTime();
                }
                case FUNC_TO_DATETIME: {
                    return typeFactory.buildDatetime();
                }
                case FUNC_TO_DECIMAL: {
                    DataType returnType;
                    SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
                    DataType left = sqlValidator.inferDataType(call.getOperand(0), scope);
                    DataType right = DataTypeFactory.instance.getMaxPrecisionDecimal();
                    DataType leftTemp = sqlValidator.getTypeCoercion().commonTypeForArithmetic(left, right, sqlValidator.getTypeFactory());
                    if (leftTemp != null) {
                        left = leftTemp;
                    }
                    if ((returnType = sqlValidator.getTypeCoercion().higherPrecision4NumberType(left, right)) == null) {
                        throw Exceptions.of((ErrorCode)ErrorCode.FunctionNotExist2, (SqlParserPosition)call.getPosition(), (Object[])new Object[]{call.getKind().name(), left.id()});
                    }
                    return returnType;
                }
            }
            throw Exceptions.of((ErrorCode)ErrorCode.FunctionNotExist1, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{sqlNode.getKind().name()});
        }
    }
}

