/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.operator;

import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.ReturnTypeInference;
import kd.bos.flydb.core.sql.operator.SqlOperatorImpl;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlUnaryOperator
extends SqlOperatorImpl {
    public static final SqlUnaryOperator operator = new SqlUnaryOperator("unary");

    public SqlUnaryOperator(String name) {
        super(name, SqlKind.UNARY, 80, true, null, (ReturnTypeInference)new UnaryReturnTypeInference());
    }

    @Override
    public void checkOperandCount(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
        SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
        if (call.getOperandCount() != 2) {
            throw Exceptions.of((ErrorCode)ErrorCode.OperatorRequireArgument, (SqlParserPosition)sqlNode.getPosition(), (Object[])new Object[]{this.name(), 2});
        }
        if (call.getOperand(0).getKind() != SqlKind.LITERAL) {
            throw Exceptions.of((ErrorCode)ErrorCode.InnerUnexpected_UnaryNeedLiteral, (Object[])new Object[0]);
        }
    }

    private static class UnaryReturnTypeInference
    implements ReturnTypeInference {
        private UnaryReturnTypeInference() {
        }

        @Override
        public DataType inferReturnType(SqlValidator sqlValidator, SqlValidatorScope scope, SqlNode sqlNode) {
            SqlBasicCall call = sqlNode.cast(SqlBasicCall.class);
            return sqlValidator.inferDataType(call.getOperand(1), scope);
        }
    }
}

