/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.parser;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.SqlSetOperator;
import kd.bos.flydb.core.sql.operator.SqlUnaryOperator;
import kd.bos.flydb.core.sql.parser.antlr4.SqlBaseVisitor;
import kd.bos.flydb.core.sql.parser.antlr4.SqlParser;
import kd.bos.flydb.core.sql.tree.SqlBasicCall;
import kd.bos.flydb.core.sql.tree.SqlCaseWhenType;
import kd.bos.flydb.core.sql.tree.SqlConditionType;
import kd.bos.flydb.core.sql.tree.SqlDynamicParam;
import kd.bos.flydb.core.sql.tree.SqlIdentifier;
import kd.bos.flydb.core.sql.tree.SqlJoin;
import kd.bos.flydb.core.sql.tree.SqlJoinType;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeList;
import kd.bos.flydb.core.sql.tree.SqlNumericLiteral;
import kd.bos.flydb.core.sql.tree.SqlOrderBy;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.tree.SqlSelect;
import kd.bos.flydb.core.sql.tree.SqlSetVariable;
import kd.bos.flydb.core.sql.tree.SqlShow;
import kd.bos.flydb.core.sql.tree.SqlShowVariables;
import kd.bos.flydb.core.sql.tree.SqlUse;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.util.KSqlTimeLiteralHandler;
import kd.bos.flydb.core.sql.util.Pair;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;

public class ASTBuilder
extends SqlBaseVisitor<SqlNode> {
    private final AtomicInteger parameterIndex = new AtomicInteger(0);

    @Override
    public SqlNode visitQuerySpecification(SqlParser.QuerySpecificationContext ctx) {
        SqlNodeList keywordList = null;
        SqlNodeList selectList = this.handleSelectItem(ctx);
        SqlNode from = this.handleFrom(ctx);
        SqlNode where = this.handleCondition(ctx);
        SqlNodeList groupBy = this.handleGroupBy(ctx);
        SqlNode having = this.handleHaving(ctx);
        SqlNodeList windowDecls = null;
        SqlNodeList orderBy = null;
        SqlNode offset = null;
        SqlNode limit = null;
        SqlNodeList hints = null;
        return new SqlSelect(this.getPos(ctx), keywordList, selectList, from, where, groupBy, having, windowDecls, orderBy, offset, limit, hints);
    }

    private SqlNodeList handleSelectItem(SqlParser.QuerySpecificationContext ctx) {
        SqlNodeList selects = new SqlNodeList(this.getPos(ctx.selectItem().get(0)));
        for (SqlParser.SelectItemContext selectItem : ctx.selectItem()) {
            selects.add((SqlNode)selectItem.accept(this));
        }
        return selects;
    }

    private SqlNode handleFrom(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.relation().size() > 1) {
            throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)this.getPos(ctx.relation(1)), (Object[])new Object[]{"cross join"});
        }
        if (ctx.relation().size() == 1) {
            return (SqlNode)ctx.relation().get(0).accept(this);
        }
        return null;
    }

    private SqlNode handleCondition(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.where == null) {
            return null;
        }
        return (SqlNode)ctx.where.accept(this);
    }

    private SqlNodeList handleGroupBy(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.groupBy() == null) {
            return null;
        }
        return (SqlNodeList)ctx.groupBy().accept(this);
    }

    private SqlNode handleHaving(SqlParser.QuerySpecificationContext ctx) {
        if (ctx.having == null) {
            return null;
        }
        return (SqlNode)ctx.having.accept(this);
    }

    @Override
    public SqlNode visitSingleStatement(SqlParser.SingleStatementContext ctx) {
        return (SqlNode)ctx.statement().accept(this);
    }

    @Override
    public SqlNode visitQueryNoWith(SqlParser.QueryNoWithContext ctx) {
        SqlNode query = (SqlNode)ctx.queryTerm().accept(this);
        SqlNodeList orderBy = null;
        SqlNumericLiteral offset = null;
        SqlNumericLiteral limit = null;
        if (ctx.sortItem() != null && ctx.sortItem().size() > 0) {
            ArrayList<SqlNode> orderList = new ArrayList<SqlNode>(ctx.sortItem().size());
            for (SqlParser.SortItemContext sortItemContext : ctx.sortItem()) {
                orderList.add(sortItemContext.accept(this));
            }
            orderBy = new SqlNodeList(this.getPos(ctx.sortItem(0)), orderList);
        }
        boolean i = false;
        if (ctx.LIMIT() != null) {
            List<TerminalNode> integerValues = ctx.INTEGER_VALUE();
            if (integerValues.size() == 1) {
                limit = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(0).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(0).getText()));
            } else {
                offset = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(0).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(0).getText()));
                limit = new SqlNumericLiteral(this.getPos(ctx.INTEGER_VALUE(1).getSymbol()), Integer.valueOf(ctx.INTEGER_VALUE(1).getText()));
            }
        }
        if (orderBy == null && offset == null && limit == null) {
            return query;
        }
        return new SqlOrderBy(this.getPos(ctx), query, orderBy, offset, limit);
    }

    @Override
    public SqlNode visitSortItem(SqlParser.SortItemContext ctx) {
        SqlNode sort = ctx.expression().accept(this);
        if (ctx.ordering == null) {
            return sort;
        }
        SqlKind sqlKind = SqlKind.ASCENDING;
        if (ctx.DESC() != null) {
            sqlKind = SqlKind.DESCENDING;
        }
        return new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), sort);
    }

    @Override
    public SqlNode visitSelectSingle(SqlParser.SelectSingleContext ctx) {
        SqlNode select = ctx.expression().accept(this);
        SqlNode alias = null;
        if (ctx.identifier() != null) {
            alias = (SqlNode)ctx.identifier().accept(this);
        }
        if (alias == null) {
            return select;
        }
        return new SqlBasicCall(this.getPos(ctx), SqlKind.AS, SqlOperators.of(SqlKind.AS), Lists.newArrayList((Object[])new SqlNode[]{select, alias}));
    }

    private void handleNameParts(List<String> names, SqlNode node) {
        if (node instanceof SqlIdentifier) {
            names.addAll(((SqlIdentifier)node).getNames());
        } else if (node instanceof SqlNodeList) {
            SqlNodeList list = (SqlNodeList)node;
            for (SqlNode sqlNode : list) {
                this.handleNameParts(names, sqlNode);
            }
        }
    }

    @Override
    public SqlNode visitDereference(SqlParser.DereferenceContext ctx) {
        ArrayList<String> names = new ArrayList<String>(ctx.children.size());
        for (ParseTree child : ctx.children) {
            SqlNode name = (SqlNode)child.accept((ParseTreeVisitor)this);
            this.handleNameParts(names, name);
        }
        return new SqlIdentifier(this.getPos(ctx), names);
    }

    @Override
    public SqlNode visitColumnReference(SqlParser.ColumnReferenceContext ctx) {
        ArrayList<SqlNode> childNodeList = new ArrayList<SqlNode>();
        for (ParseTree child : ctx.children) {
            SqlNode name = (SqlNode)child.accept((ParseTreeVisitor)this);
            if (name == null) continue;
            childNodeList.add(name);
        }
        if (childNodeList.size() == 1) {
            return (SqlNode)childNodeList.get(0);
        }
        SqlNodeList sqlNodeList = new SqlNodeList(this.getPos(ctx));
        sqlNodeList.addAll((Collection<? extends SqlNode>)childNodeList);
        return sqlNodeList;
    }

    @Override
    public SqlNode visitParenthesizedExpression(SqlParser.ParenthesizedExpressionContext ctx) {
        return (SqlNode)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public SqlNode visitParameter(SqlParser.ParameterContext ctx) {
        return new SqlDynamicParam(this.getPos(ctx), this.parameterIndex.getAndIncrement());
    }

    @Override
    public SqlNode visitNullLiteral(SqlParser.NullLiteralContext ctx) {
        return new SqlLiteral(this.getPos(ctx), null, DataTypeFactory.instance.buildNullType());
    }

    @Override
    public SqlNode visitSelectAll(SqlParser.SelectAllContext ctx) {
        ArrayList<String> names = new ArrayList<String>();
        if (ctx.qualifiedName() != null) {
            SqlIdentifier identifier = (SqlIdentifier)ctx.qualifiedName().accept(this);
            names.addAll(identifier.getNames());
        }
        if (ctx.ASTERISK() != null) {
            names.add("*");
        }
        return new SqlIdentifier(this.getPos(ctx), names);
    }

    @Override
    public SqlNode visitUnquotedIdentifier(SqlParser.UnquotedIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos(ctx), Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    @Override
    public SqlNode visitQuotedIdentifier(SqlParser.QuotedIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos(ctx), Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    @Override
    public SqlNode visitBackQuotedIdentifier(SqlParser.BackQuotedIdentifierContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1);
        return new SqlIdentifier(this.getPos(ctx), Lists.newArrayList((Object[])new String[]{text}));
    }

    @Override
    public SqlNode visitDigitIdentifier(SqlParser.DigitIdentifierContext ctx) {
        return new SqlIdentifier(this.getPos(ctx), Lists.newArrayList((Object[])new String[]{ctx.getText()}));
    }

    private SqlParserPosition getPos(ParserRuleContext parserRuleContext) {
        return new SqlParserPosition(parserRuleContext.getStart().getLine(), parserRuleContext.getStart().getStartIndex());
    }

    private SqlParserPosition getPos(Token token) {
        return new SqlParserPosition(token.getLine(), token.getStartIndex());
    }

    @Override
    public SqlNode visitFunctionCall(SqlParser.FunctionCallContext ctx) {
        SqlIdentifier nameNode = (SqlIdentifier)ctx.qualifiedName().accept(this);
        if (ctx.ASTERISK() != null) {
            SqlOperator operator = SqlOperators.unresolvedFunc(nameNode.getNames().get(0));
            return new SqlBasicCall(this.getPos(ctx), SqlKind.UNRESOLVED_FUNCTION, operator, SqlIdentifier.createStar(this.getPos(ctx.ASTERISK().getSymbol())));
        }
        SqlOperator operator = SqlOperators.unresolvedFunc(nameNode.getNames().get(0));
        if (ctx.expression() != null) {
            ArrayList<SqlNode> paramsNode = new ArrayList<SqlNode>(ctx.expression().size());
            for (SqlParser.ExpressionContext expressionContext : ctx.expression()) {
                paramsNode.add(expressionContext.accept(this));
            }
            return new SqlBasicCall(this.getPos(ctx), SqlKind.UNRESOLVED_FUNCTION, operator, paramsNode);
        }
        return new SqlBasicCall(this.getPos(ctx), SqlKind.UNRESOLVED_FUNCTION, operator, Collections.emptyList());
    }

    @Override
    public SqlNode visitSimpleCase(SqlParser.SimpleCaseContext ctx) {
        SqlLiteral caseType = SqlCaseWhenType.SimpleCase.symbol(this.getPos(ctx));
        SqlNode valueNode = null;
        SqlNode elseNode = null;
        SqlParser.ValueExpressionContext valueExpressionContext = ctx.valueExpression();
        List<SqlParser.WhenClauseContext> whenClauseContexts = ctx.whenClause();
        if (valueExpressionContext != null) {
            valueNode = (SqlNode)valueExpressionContext.accept(this);
        }
        ArrayList<SqlNode> whenList = new ArrayList<SqlNode>(whenClauseContexts.size());
        ArrayList<SqlNode> thenList = new ArrayList<SqlNode>(whenClauseContexts.size());
        for (SqlParser.WhenClauseContext whenClauseContext : whenClauseContexts) {
            whenList.add(whenClauseContext.condition.accept(this));
            thenList.add(whenClauseContext.result.accept(this));
        }
        SqlNodeList whenNodeList = new SqlNodeList(this.getPos(whenClauseContexts.get((int)0).condition), whenList);
        SqlNodeList thenNodeList = new SqlNodeList(this.getPos(whenClauseContexts.get((int)0).result), thenList);
        elseNode = ctx.elseExpression != null ? ctx.elseExpression.accept(this) : new SqlLiteral(this.getPos(ctx), null, DataTypeFactory.instance.buildNullType());
        return new SqlBasicCall(this.getPos(ctx), SqlKind.CASE, SqlOperators.of(SqlKind.CASE), caseType, valueNode, whenNodeList, thenNodeList, elseNode);
    }

    @Override
    public SqlNode visitSearchedCase(SqlParser.SearchedCaseContext ctx) {
        SqlLiteral caseType = SqlCaseWhenType.SearchedCase.symbol(this.getPos(ctx));
        SqlNode elseNode = null;
        List<SqlParser.WhenClauseContext> whenClauseContexts = ctx.whenClause();
        ArrayList<SqlNode> whenList = new ArrayList<SqlNode>(whenClauseContexts.size());
        ArrayList<SqlNode> thenList = new ArrayList<SqlNode>(whenClauseContexts.size());
        for (SqlParser.WhenClauseContext whenClauseContext : whenClauseContexts) {
            whenList.add(whenClauseContext.condition.accept(this));
            thenList.add(whenClauseContext.result.accept(this));
        }
        SqlNodeList whenNodeList = new SqlNodeList(this.getPos(whenClauseContexts.get((int)0).condition), whenList);
        SqlNodeList thenNodeList = new SqlNodeList(this.getPos(whenClauseContexts.get((int)0).result), thenList);
        elseNode = ctx.elseExpression != null ? ctx.elseExpression.accept(this) : new SqlLiteral(this.getPos(ctx), null, DataTypeFactory.instance.buildNullType());
        return new SqlBasicCall(this.getPos(ctx), SqlKind.CASE, SqlOperators.of(SqlKind.CASE), caseType, whenNodeList, thenNodeList, elseNode);
    }

    @Override
    public SqlNode visitDecimalLiteral(SqlParser.DecimalLiteralContext ctx) {
        return new SqlNumericLiteral(this.getPos(ctx), new BigDecimal(ctx.DECIMAL_VALUE().getText()));
    }

    @Override
    public SqlNode visitDoubleLiteral(SqlParser.DoubleLiteralContext ctx) {
        String numeric = ctx.DOUBLE_VALUE().getText();
        return new SqlNumericLiteral(this.getPos(ctx), BigDecimal.valueOf(Double.parseDouble(numeric)));
    }

    @Override
    public SqlNode visitIntegerLiteral(SqlParser.IntegerLiteralContext ctx) {
        String numeric = ctx.INTEGER_VALUE().getText();
        Long value = Long.parseLong(numeric);
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            return new SqlNumericLiteral(this.getPos(ctx), value);
        }
        return new SqlNumericLiteral(this.getPos(ctx), value.intValue());
    }

    @Override
    public SqlNode visitBigIntLiteral(SqlParser.BigIntLiteralContext ctx) {
        String numeric = ctx.BIGINT_VALUE().getText();
        long value = Long.parseLong(numeric.substring(0, numeric.length() - 1));
        return new SqlNumericLiteral(this.getPos(ctx), value);
    }

    @Override
    public SqlNode visitKsqlTimeLiteral(SqlParser.KsqlTimeLiteralContext ctx) {
        String flag = ctx.IDENTIFIER().getText();
        String pattern = ctx.STRING().getText();
        Pair<DataType, Temporal> pair = KSqlTimeLiteralHandler.pair(flag, pattern);
        return new SqlLiteral(this.getPos(ctx), pair.getValue(), pair.getType());
    }

    @Override
    public SqlNode visitTypeConstructor(SqlParser.TypeConstructorContext ctx) {
        String typeName;
        SqlIdentifier type = (SqlIdentifier)ctx.identifier().accept(this);
        SqlParserPosition pos = this.getPos(ctx);
        String string = ctx.string().getText();
        switch (typeName = type.getNames().get(0).toUpperCase(Locale.ENGLISH)) {
            case "TIME": 
            case "DATE": 
            case "DATETIME": {
                Pair<DataType, Temporal> pair = KSqlTimeLiteralHandler.pair(typeName, string);
                return new SqlLiteral(pos, pair.getValue(), pair.getType());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlNode visitSpecialDateTimeFunction(SqlParser.SpecialDateTimeFunctionContext ctx) {
        if (ctx.precision != null) {
            throw new UnsupportedOperationException(ctx.name.getText());
        }
        switch (ctx.name.getType()) {
            case 42: {
                return new SqlLiteral(this.getPos(ctx), LocalDate.now(), DataTypeFactory.instance.buildDate());
            }
            case 45: {
                return new SqlLiteral(this.getPos(ctx), LocalDateTime.now(), DataTypeFactory.instance.buildDatetime());
            }
            case 111: {
                return new SqlLiteral(this.getPos(ctx), LocalDateTime.now(), DataTypeFactory.instance.buildDatetime());
            }
            case 44: 
            case 110: {
                throw new UnsupportedOperationException(ctx.name.getText());
            }
        }
        throw new UnsupportedOperationException(ctx.name.getText());
    }

    @Override
    public SqlNode visitBasicStringLiteral(SqlParser.BasicStringLiteralContext ctx) {
        String text = ctx.getText();
        text = text.substring(1, text.length() - 1);
        return new SqlLiteral(this.getPos(ctx), text, DataTypeFactory.instance.buildString());
    }

    @Override
    public SqlNode visitArithmeticUnary(SqlParser.ArithmeticUnaryContext ctx) {
        SqlNode value = (SqlNode)ctx.valueExpression().accept(this);
        if (ctx.PLUS() != null) {
            return value;
        }
        SqlLiteral literal = new SqlLiteral(this.getPos(ctx), "-");
        return new SqlBasicCall(this.getPos(ctx), SqlKind.UNARY, (SqlOperator)SqlUnaryOperator.operator, literal, value);
    }

    @Override
    public SqlNode visitArithmeticBinary(SqlParser.ArithmeticBinaryContext ctx) {
        SqlKind sqlKind = null;
        if (ctx.PLUS() != null) {
            sqlKind = SqlKind.PLUS;
        } else if (ctx.MINUS() != null) {
            sqlKind = SqlKind.MINUS;
        } else if (ctx.ASTERISK() != null) {
            sqlKind = SqlKind.TIMES;
        } else if (ctx.PERCENT() != null) {
            sqlKind = SqlKind.MOD;
        } else if (ctx.SLASH() != null) {
            sqlKind = SqlKind.DIVIDE;
        }
        ArrayList<SqlNode> operandList = new ArrayList<SqlNode>(ctx.valueExpression().size());
        for (SqlParser.ValueExpressionContext operand : ctx.valueExpression()) {
            operandList.add((SqlNode)operand.accept(this));
        }
        return new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), operandList);
    }

    @Override
    public SqlNode visitLogicalBinary(SqlParser.LogicalBinaryContext ctx) {
        SqlKind sqlKind;
        if (ctx.AND() != null) {
            sqlKind = SqlKind.AND;
        } else if (ctx.OR() != null) {
            sqlKind = SqlKind.OR;
        } else {
            throw new UnsupportedOperationException();
        }
        ArrayList<SqlNode> operandList = new ArrayList<SqlNode>(2);
        for (SqlParser.BooleanExpressionContext booleanExpressionContext : ctx.booleanExpression()) {
            operandList.add((SqlNode)booleanExpressionContext.accept(this));
        }
        return new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), operandList);
    }

    @Override
    public SqlNode visitTableName(SqlParser.TableNameContext ctx) {
        ArrayList<String> names = new ArrayList<String>(ctx.qualifiedName().identifier().size());
        for (SqlParser.IdentifierContext identifierContext : ctx.qualifiedName().identifier()) {
            SqlIdentifier node = (SqlIdentifier)identifierContext.accept(this);
            names.addAll(node.getNames());
        }
        return new SqlIdentifier(this.getPos(ctx), names);
    }

    @Override
    public SqlNode visitAliasedRelation(SqlParser.AliasedRelationContext ctx) {
        SqlNode relation = (SqlNode)ctx.relationPrimary().accept(this);
        if (ctx.identifier() != null) {
            SqlNode alias = (SqlNode)ctx.identifier().accept(this);
            return new SqlBasicCall(this.getPos(ctx), SqlKind.AS, SqlOperators.of(SqlKind.AS), Lists.newArrayList((Object[])new SqlNode[]{relation, alias}));
        }
        if (ctx.columnAliases() != null) {
            throw new UnsupportedOperationException();
        }
        return relation;
    }

    @Override
    public SqlNode visitJoinRelation(SqlParser.JoinRelationContext ctx) {
        SqlLiteral joinTypeNode = null;
        SqlLiteral conditionTypeNode = null;
        SqlNode joinCriteria = null;
        SqlConditionType conditionType = null;
        if (ctx.NATURAL() != null) {
            conditionType = SqlConditionType.NATURAL;
        }
        if (ctx.CROSS() != null || ctx.JOIN() == null) {
            joinTypeNode = SqlJoinType.CROSS.symbol(this.getPos(ctx));
            throw Exceptions.of((ErrorCode)ErrorCode.SyntaxError, (SqlParserPosition)this.getPos(ctx.CROSS().getSymbol()), (Object[])new Object[]{ctx.CROSS().getText()});
        }
        if (ctx.joinType() != null) {
            joinTypeNode = (SqlLiteral)ctx.joinType().accept(this);
        }
        if (ctx.joinCriteria() != null) {
            if (ctx.joinCriteria().ON() != null) {
                conditionType = SqlConditionType.ON;
            }
            joinCriteria = ctx.joinCriteria().accept(this);
        }
        if (conditionType != null) {
            conditionTypeNode = conditionType.symbol(this.getPos(ctx));
        }
        SqlNode left = (SqlNode)ctx.left.accept(this);
        SqlNode right = ctx.right != null ? ctx.right.accept(this) : (SqlNode)ctx.rightRelation.accept(this);
        return new SqlJoin(this.getPos(ctx), left, joinTypeNode, conditionTypeNode, right, joinCriteria);
    }

    @Override
    public SqlNode visitJoinCriteria(SqlParser.JoinCriteriaContext ctx) {
        return (SqlNode)ctx.booleanExpression().accept(this);
    }

    @Override
    public SqlNode visitJoinType(SqlParser.JoinTypeContext ctx) {
        if (ctx.INNER() != null) {
            return SqlJoinType.INNER.symbol(this.getPos(ctx));
        }
        if (ctx.LEFT() != null) {
            return SqlJoinType.LEFT.symbol(this.getPos(ctx));
        }
        if (ctx.RIGHT() != null) {
            return SqlJoinType.RIGHT.symbol(this.getPos(ctx));
        }
        if (ctx.FULL() != null) {
            return SqlJoinType.FULL.symbol(this.getPos(ctx));
        }
        throw new AssertionError((Object)ctx.getText());
    }

    @Override
    public SqlNode visitPredicated(SqlParser.PredicatedContext ctx) {
        SqlNodeList nodeList;
        SqlNode left = (SqlNode)ctx.valueExpression.accept(this);
        if (ctx.predicate() == null) {
            return left;
        }
        SqlNode right = (SqlNode)ctx.predicate().accept(this);
        if (right instanceof SqlNodeList && !(nodeList = (SqlNodeList)right).isEmpty() && nodeList.get(0) instanceof SqlBasicCall) {
            SqlBasicCall call = (SqlBasicCall)nodeList.get(0);
            SqlKind callKind = call.getKind();
            if (callKind.isBelong(SqlKind.COMPARISON_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), left, nodeList.get(1));
            }
            if (callKind.isBelong(SqlKind.IN_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), left, nodeList.get(1));
            }
            if (call.isBelong(SqlKind.LIKE_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), left, nodeList.get(1));
            }
            if (call.isBelong(SqlKind.IS_NULL_KINDS)) {
                return new SqlBasicCall(call.getPosition(), callKind, call.getOperator(), left);
            }
        }
        throw new UnsupportedOperationException("Unsupported Operation");
    }

    @Override
    public SqlNode visitComparison(SqlParser.ComparisonContext ctx) {
        SqlNode call = ctx.comparisonOperator().accept(this);
        SqlNode right = (SqlNode)ctx.right.accept(this);
        return new SqlNodeList(this.getPos(ctx), Lists.newArrayList((Object[])new SqlNode[]{call, right}));
    }

    @Override
    public SqlNode visitComparisonOperator(SqlParser.ComparisonOperatorContext ctx) {
        SqlKind sqlKind;
        if (ctx.EQ() != null) {
            sqlKind = SqlKind.EQUALS;
        } else if (ctx.NEQ() != null) {
            sqlKind = SqlKind.NOT_EQUALS;
        } else if (ctx.LT() != null) {
            sqlKind = SqlKind.LESS_THAN;
        } else if (ctx.LTE() != null) {
            sqlKind = SqlKind.LESS_THAN_OR_EQUALS;
        } else if (ctx.GT() != null) {
            sqlKind = SqlKind.GREATER_THAN;
        } else if (ctx.GTE() != null) {
            sqlKind = SqlKind.GREATER_THAN_OR_EQUALS;
        } else {
            throw new UnsupportedOperationException();
        }
        return new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), Collections.emptyList());
    }

    @Override
    public SqlNode visitBooleanValue(SqlParser.BooleanValueContext ctx) {
        return new SqlLiteral(this.getPos(ctx), ctx.getText(), DataTypeFactory.instance.buildBoolean());
    }

    @Override
    public SqlNode visitInList(SqlParser.InListContext ctx) {
        SqlKind sqlKind = SqlKind.IN;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_IN;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), Collections.emptyList());
        ArrayList<SqlNode> inList = new ArrayList<SqlNode>(ctx.expression().size());
        for (SqlParser.ExpressionContext expressionContext : ctx.expression()) {
            inList.add(expressionContext.accept(this));
        }
        return new SqlNodeList(this.getPos(ctx), Lists.newArrayList((Object[])new SqlNode[]{call, new SqlNodeList(this.getPos(ctx.expression(0)), inList)}));
    }

    @Override
    public SqlNode visitInSubquery(SqlParser.InSubqueryContext ctx) {
        SqlKind sqlKind = SqlKind.IN;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_IN;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), Collections.emptyList());
        return new SqlNodeList(this.getPos(ctx), Lists.newArrayList((Object[])new SqlNode[]{call, ctx.query().accept(this)}));
    }

    @Override
    public SqlNode visitSubqueryRelation(SqlParser.SubqueryRelationContext ctx) {
        return ctx.query().accept(this);
    }

    @Override
    public SqlNode visitLike(SqlParser.LikeContext ctx) {
        SqlKind sqlKind = SqlKind.LIKE;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.NOT_LIKE;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), Collections.emptyList());
        if (ctx.ESCAPE() != null) {
            throw new UnsupportedOperationException();
        }
        return new SqlNodeList(this.getPos(ctx), Lists.newArrayList((Object[])new SqlNode[]{call, (SqlNode)ctx.pattern.accept(this)}));
    }

    @Override
    public SqlNode visitNullPredicate(SqlParser.NullPredicateContext ctx) {
        SqlKind sqlKind = SqlKind.IS_NULL;
        if (ctx.NOT() != null) {
            sqlKind = SqlKind.IS_NOT_NULL;
        }
        SqlBasicCall call = new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), Collections.emptyList());
        return new SqlNodeList(this.getPos(ctx), Lists.newArrayList((Object[])new SqlNode[]{call}));
    }

    @Override
    public SqlNode visitLogicalNot(SqlParser.LogicalNotContext ctx) {
        SqlKind sqlKind = SqlKind.NOT;
        SqlNode operand = (SqlNode)ctx.booleanExpression().accept(this);
        return new SqlBasicCall(this.getPos(ctx), sqlKind, SqlOperators.of(sqlKind), operand);
    }

    @Override
    public SqlNode visitGroupBy(SqlParser.GroupByContext ctx) {
        ArrayList<SqlNode> groupList = new ArrayList<SqlNode>(ctx.groupingElement().size());
        for (SqlParser.GroupingElementContext elementContext : ctx.groupingElement()) {
            groupList.add((SqlNode)elementContext.accept(this));
        }
        return new SqlNodeList(this.getPos(ctx), groupList);
    }

    @Override
    public SqlNode visitGroupingSet(SqlParser.GroupingSetContext ctx) {
        if (ctx.expression().size() > 1) {
            throw new UnsupportedOperationException();
        }
        return ctx.expression(0).accept(this);
    }

    @Override
    public SqlNode visitCast(SqlParser.CastContext ctx) {
        SqlOperator operator = SqlOperators.of(SqlKind.FUNC_CAST);
        if (ctx.expression() == null) {
            throw new UnsupportedOperationException();
        }
        if (ctx.type() == null) {
            throw new UnsupportedOperationException();
        }
        SqlNode expression = ctx.expression().accept(this);
        SqlIdentifier type = (SqlIdentifier)ctx.type().accept(this);
        if (type.getNames().size() > 1) {
            throw new UnsupportedOperationException("unsupported cast type");
        }
        SqlLiteral typeLiteral = new SqlLiteral(type.getPosition(), type.getLast(), DataTypeFactory.instance.buildString());
        return new SqlBasicCall(this.getPos(ctx), SqlKind.FUNC_CAST, operator, Lists.newArrayList((Object[])new SqlNode[]{expression, typeLiteral}));
    }

    @Override
    public SqlNode visitShowDatabases(SqlParser.ShowDatabasesContext ctx) {
        return new SqlShow(this.getPos(ctx), SqlKind.SHOW_DATABASES);
    }

    @Override
    public SqlNode visitShowSessions(SqlParser.ShowSessionsContext ctx) {
        return new SqlShow(this.getPos(ctx), SqlKind.SHOW_SESSIONS);
    }

    @Override
    public SqlNode visitShowColumns(SqlParser.ShowColumnsContext ctx) {
        SqlIdentifier from = null;
        if (ctx.qualifiedName() != null) {
            ArrayList<String> names = new ArrayList<String>(ctx.qualifiedName().identifier().size());
            for (SqlParser.IdentifierContext identifierContext : ctx.qualifiedName().identifier()) {
                SqlIdentifier node = (SqlIdentifier)identifierContext.accept(this);
                names.addAll(node.getNames());
            }
            from = new SqlIdentifier(this.getPos(ctx), names);
        }
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept(this);
        return new SqlShow(this.getPos(ctx), SqlKind.SHOW_COLUMNS, from, where);
    }

    @Override
    public SqlNode visitShowTables(SqlParser.ShowTablesContext ctx) {
        SqlNode from = null;
        if (ctx.qualifiedName() != null) {
            from = (SqlNode)this.visitQualifiedName(ctx.qualifiedName());
        }
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept(this);
        return new SqlShow(this.getPos(ctx), SqlKind.SHOW_TABLES, from, where);
    }

    @Override
    public SqlNode visitShowVariables(SqlParser.ShowVariablesContext ctx) {
        if (ctx.pattern == null) {
            return new SqlShowVariables(this.getPos(ctx), ctx.GLOBAL() != null, null);
        }
        return new SqlShowVariables(this.getPos(ctx), ctx.GLOBAL() != null, (SqlNode)ctx.pattern.accept(this));
    }

    @Override
    public SqlNode visitShowSchemas(SqlParser.ShowSchemasContext ctx) {
        SqlNode where = ctx.where == null ? null : (SqlNode)ctx.where.accept(this);
        return new SqlShow(this.getPos(ctx), SqlKind.SHOW_SCHEMAS, null, where);
    }

    @Override
    public SqlNode visitUse(SqlParser.UseContext ctx) {
        ArrayList<String> names = new ArrayList<String>(ctx.identifier().size());
        for (SqlParser.IdentifierContext identifierContext : ctx.identifier()) {
            SqlIdentifier node = (SqlIdentifier)identifierContext.accept(this);
            names.addAll(node.getNames());
        }
        return new SqlUse(this.getPos(ctx), SqlKind.USE, names);
    }

    @Override
    public SqlNode visitSetSessionVariable(SqlParser.SetSessionVariableContext ctx) {
        return new SqlSetVariable(this.getPos(ctx), (SqlNode)ctx.key.accept(this), (SqlNode)ctx.value.accept(this));
    }

    @Override
    public SqlNode visitSetOperation(SqlParser.SetOperationContext ctx) {
        SqlKind sqlKind;
        switch (ctx.operator.getType()) {
            case 202: {
                sqlKind = SqlKind.UNION;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        SqlParser.SetQuantifierContext quantifier = ctx.setQuantifier();
        boolean isAll = quantifier != null && quantifier.ALL() != null;
        boolean isDistinct = quantifier != null && quantifier.DISTINCT() != null;
        SqlNode left = (SqlNode)ctx.left.accept(this);
        SqlNode right = (SqlNode)ctx.right.accept(this);
        String quantifierName = "";
        if (isAll) {
            quantifierName = " ALL";
        }
        if (isDistinct) {
            quantifierName = " DISTINCT";
        }
        SqlSetOperator sqlSetOperator = new SqlSetOperator(sqlKind.getName() + quantifierName, sqlKind, isAll);
        return new SqlBasicCall(this.getPos(ctx), sqlKind, (SqlOperator)sqlSetOperator, left, right);
    }

    @Override
    public SqlNode visitSubquery(SqlParser.SubqueryContext ctx) {
        return ctx.queryNoWith().accept(this);
    }

    @Override
    public SqlNode visitSubqueryExpression(SqlParser.SubqueryExpressionContext ctx) {
        throw Exceptions.of((ErrorCode)ErrorCode.UnsupportedFeature, (SqlParserPosition)this.getPos(ctx), (Object[])new Object[]{"subquery expression"});
    }
}

