/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.parser;

import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.common.exception.CoreException;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.parser.ASTBuilder;
import kd.bos.flydb.core.sql.parser.ParserConfig;
import kd.bos.flydb.core.sql.parser.antlr4.SqlLexer;
import kd.bos.flydb.core.sql.parser.antlr4.SqlParser;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class Parser {
    private ParserConfig config;
    private ErrorListener errorListener = new ErrorListenerImpl();
    private ExceptionHandle exceptionHandle = new ExceptionHandleImpl();

    public Parser(ParserConfig config) {
        this.config = config;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setExceptionHandle(ExceptionHandle exceptionHandle) {
        this.exceptionHandle = exceptionHandle;
    }

    public SqlParser getParser(String sql) {
        SqlLexer lexer = new SqlLexer((CharStream)CharStreams.fromString((String)sql));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new SqlParser((TokenStream)tokens);
    }

    public SqlNode parse(String sql) {
        SqlParser parser = this.getParser(sql);
        parser.removeErrorListeners();
        parser.addErrorListener(this.errorListener);
        SqlParser.SingleStatementContext parseTree = parser.singleStatement();
        if (parseTree.exception != null) {
            this.exceptionHandle.handle((Exception)((Object)parseTree.exception));
        }
        if (!this.errorListener.getExceptions().isEmpty()) {
            this.exceptionHandle.handle(this.errorListener.getExceptions().get(0));
        }
        ASTBuilder builder = new ASTBuilder();
        return (SqlNode)parseTree.accept(builder);
    }

    public static class ExceptionHandleImpl
    implements ExceptionHandle {
        private static CoreException rethrow(Exception exception) {
            if (exception instanceof CoreException) {
                return (CoreException)((Object)exception);
            }
            if (exception instanceof RecognitionException) {
                RecognitionException recognitionException = (RecognitionException)((Object)exception);
                Token token = recognitionException.getOffendingToken();
                return Exceptions.of((ErrorCode)ErrorCode.SyntaxError, (SqlParserPosition)new SqlParserPosition(token.getLine(), token.getStartIndex()), (Object[])new Object[]{recognitionException.getOffendingToken().getText()});
            }
            return Exceptions.of((ErrorCode)ErrorCode.SyntaxError2, (Object[])new Object[]{exception.getMessage()});
        }

        @Override
        public void handle(Exception exception) {
            if (exception == null) {
                return;
            }
            throw ExceptionHandleImpl.rethrow(exception);
        }
    }

    public static interface ErrorListener
    extends ANTLRErrorListener {
        public List<Exception> getExceptions();
    }

    public static interface ExceptionHandle {
        public void handle(Exception var1);
    }

    private static class ErrorListenerImpl
    extends BaseErrorListener
    implements ErrorListener {
        private final List<Exception> exceptions = new ArrayList<Exception>();

        private ErrorListenerImpl() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            super.syntaxError(recognizer, offendingSymbol, line, charPositionInLine, msg, e);
            if (e != null) {
                this.exceptions.add((Exception)((Object)e));
            } else if (offendingSymbol instanceof Token) {
                this.exceptions.add((Exception)((Object)Exceptions.of((ErrorCode)ErrorCode.SyntaxError, (SqlParserPosition)new SqlParserPosition(line, charPositionInLine), (Object[])new Object[]{((Token)offendingSymbol).getText()})));
            } else {
                this.exceptions.add((Exception)((Object)Exceptions.of((ErrorCode)ErrorCode.SyntaxError1, (SqlParserPosition)new SqlParserPosition(line, charPositionInLine), (Object[])new Object[0])));
            }
        }

        @Override
        public List<Exception> getExceptions() {
            return this.exceptions;
        }
    }
}

