/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlBasicCall
extends SqlCall {
    private final List<SqlNode> operandList = new ArrayList<SqlNode>();
    private SqlOperator sqlOperator;

    public SqlBasicCall(SqlParserPosition position, SqlKind sqlKind, SqlOperator sqlOperator, SqlNode ... operands) {
        this(position, sqlKind, sqlOperator, Arrays.asList(operands));
    }

    public SqlBasicCall(SqlParserPosition position, SqlKind sqlKind, SqlOperator sqlOperator, List<SqlNode> operands) {
        super(position, sqlKind);
        this.sqlOperator = sqlOperator;
        this.operandList.addAll(operands);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    public void setOperator(SqlOperator sqlOperator) {
        this.sqlOperator = sqlOperator;
        this.sqlKind = this.sqlOperator.getKind();
    }

    @Override
    public void setOperand(int i, SqlNode node) {
        this.operandList.set(i, node);
    }

    @Override
    public List<SqlNode> getOperandList() {
        return this.operandList;
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlBasicCall(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operandList, this.sqlOperator});
    }

    @Override
    public boolean equalsOnExpression(SqlNode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlBasicCall other = (SqlBasicCall)o;
        if (this.sqlOperator.getKind() != other.sqlOperator.getKind()) {
            return false;
        }
        if (this.operandList.size() != other.operandList.size()) {
            return false;
        }
        for (int i = 0; i < this.operandList.size(); ++i) {
            if (this.operandList.get(i).equalsOnExpression(other.operandList.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateBasicCall(this);
    }

    public String toString() {
        String op = this.sqlOperator.toString();
        if ((op.equals("AS") || op.equals("IN")) && this.operandList.size() == 2) {
            return this.operandList.get(0) + " " + this.sqlOperator.toString() + " " + this.operandList.get(1);
        }
        return op + " " + this.operandList;
    }
}

