/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import java.util.List;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.operator.UnresolvedFunctionOperator;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeBase;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.unparse.SqlDialect;
import kd.bos.flydb.core.sql.unparse.SqlWriter;

public abstract class SqlCall
extends SqlNodeBase {
    public SqlCall(SqlParserPosition position, SqlKind sqlKind) {
        super(position, sqlKind);
    }

    public abstract SqlOperator getOperator();

    public abstract List<SqlNode> getOperandList();

    public int getOperandCount() {
        return this.getOperandList().size();
    }

    public SqlNode getOperand(int i) {
        return this.getOperandList().get(i);
    }

    public void setOperand(int i, SqlNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unParse(SqlWriter writer, int leftPrecedence, int rightPrecedence) {
        SqlOperator operator = this.getOperator();
        if (operator.getKind() == SqlKind.UNRESOLVED_FUNCTION) {
            UnresolvedFunctionOperator unresolvedOperator = (UnresolvedFunctionOperator)operator;
            SqlOperator functionOperator = SqlOperators.func(unresolvedOperator.name());
            functionOperator.unParse(writer, this, functionOperator.getLeftPrecedence(), functionOperator.getRightPrecedence());
        } else {
            SqlDialect dialect = writer.getDialect();
            if (leftPrecedence > operator.getLeftPrecedence() || operator.getRightPrecedence() <= rightPrecedence && rightPrecedence != 0 || writer.isAlwaysUseParentheses() && this.getKind() != null) {
                SqlWriter.Frame frame = writer.startList("(", ")");
                dialect.unParseCall(writer, this, 0, 0);
                writer.endList(frame);
            } else {
                dialect.unParseCall(writer, this, leftPrecedence, rightPrecedence);
            }
        }
    }
}

