/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeBase;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.unparse.SqlUtil;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;
import org.apache.commons.collections4.ListUtils;

public class SqlIdentifier
extends SqlNodeBase {
    private final List<String> names;

    public SqlIdentifier(SqlParserPosition position, List<String> names) {
        super(position, SqlKind.IDENTIFIER);
        ArrayList<String> upperNames = new ArrayList<String>(names.size());
        for (String name : names) {
            upperNames.add(name);
        }
        this.names = upperNames;
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.names);
    }

    public static SqlIdentifier createStar(SqlParserPosition position) {
        return new SqlIdentifier(position, Lists.newArrayList((Object[])new String[]{"*"}));
    }

    public boolean isStar() {
        for (String name : this.names) {
            if (!name.equals("*")) continue;
            return true;
        }
        return false;
    }

    public boolean isSimpleStar() {
        return this.isSimple() && this.getSimple().equals("*");
    }

    public boolean isSimple() {
        return this.names.size() == 1;
    }

    public String getSimple() {
        assert (this.names.size() == 1);
        return this.names.get(0);
    }

    public String getLast() {
        assert (!this.names.isEmpty());
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlIdentifier(this);
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.names});
    }

    @Override
    public boolean equalsOnExpression(SqlNode other) {
        if (!(other instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier o = (SqlIdentifier)other;
        return ListUtils.isEqualList(this.names, o.names);
    }

    @Override
    public void unParse(SqlWriter writer, int leftPrecedence, int rightPrecedence) {
        SqlUtil.unParseSqlIdentifierSyntax(writer, this, false);
    }

    public String toString() {
        return String.join((CharSequence)".", this.names);
    }
}

