/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.flydb.common.exception.ErrorCode;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.operator.SqlOperator;
import kd.bos.flydb.core.sql.operator.SqlOperators;
import kd.bos.flydb.core.sql.tree.SqlCall;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlLiteral;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlJoin
extends SqlCall {
    public static final int LEFT_OPERAND = 0;
    public static final int JOIN_TYPE_OPERAND = 1;
    public static final int CONDITION_TYPE_OPERAND = 2;
    public static final int RIGHT_OPERAND = 3;
    public static final int CONDITION_OPERAND = 4;
    private static final int OPERAND_COUNT = 5;
    private SqlNode left;
    private SqlLiteral joinType;
    private SqlLiteral conditionType;
    private SqlNode right;
    private SqlNode condition;
    private final SqlOperator sqlOperator;

    public SqlJoin(SqlParserPosition pos, SqlNode left, SqlLiteral joinType, SqlLiteral conditionType, SqlNode right, SqlNode condition) {
        super(pos, SqlKind.JOIN);
        this.left = left;
        this.joinType = joinType;
        this.conditionType = conditionType;
        this.right = right;
        this.condition = condition;
        this.sqlOperator = SqlOperators.of(SqlKind.JOIN);
    }

    @Override
    public SqlOperator getOperator() {
        return this.sqlOperator;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Lists.newArrayList((Object[])new SqlNode[]{this.left, this.joinType, this.conditionType, this.right, this.condition});
    }

    @Override
    public int getOperandCount() {
        return 5;
    }

    @Override
    public SqlNode getOperand(int i) {
        switch (i) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.joinType;
            }
            case 2: {
                return this.conditionType;
            }
            case 3: {
                return this.right;
            }
            case 4: {
                return this.condition;
            }
        }
        throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.left = operand;
                break;
            }
            case 1: {
                this.joinType = (SqlLiteral)operand;
                break;
            }
            case 2: {
                this.conditionType = (SqlLiteral)operand;
                break;
            }
            case 3: {
                this.right = operand;
                break;
            }
            case 4: {
                this.condition = operand;
                break;
            }
            default: {
                throw Exceptions.of((ErrorCode)ErrorCode.Unexpected, (Object[])new Object[0]);
            }
        }
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlJoin(this);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    public SqlNode getLeft() {
        return this.left;
    }

    public SqlLiteral getJoinType() {
        return this.joinType;
    }

    public SqlNode getRight() {
        return this.right;
    }

    public SqlLiteral getConditionType() {
        return this.conditionType;
    }

    public SqlNode getCondition() {
        return this.condition;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.left, this.joinType, this.conditionType, this.right, this.condition, this.sqlOperator});
    }
}

