/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.collect.Lists;
import java.util.HashSet;

public enum SqlKind {
    OTHER,
    SELECT,
    ORDER_BY,
    IDENTIFIER,
    LITERAL,
    DYNAMIC_PARAM,
    UNARY("-"),
    SHOW_DATABASES("SHOW DATABASES"),
    SHOW_SESSIONS("SHOW SESSIONS"),
    SHOW_COLUMNS("SHOW COLUMNS"),
    SHOW_TABLES("SHOW TABLES"),
    SHOW_SCHEMAS("SHOW SCHEMAS"),
    USE,
    SHOW_VARIABLES("SHOW VARIABLES"),
    SET_SESSION_VARIABLE("SET SESSION VARIABLE"),
    UNION,
    EXPECT,
    INTERSECT,
    CASE,
    AS,
    UNRESOLVED_FUNCTION,
    JOIN,
    ASCENDING("ASC"),
    DESCENDING("DESC"),
    PLUS("+"),
    MINUS("-"),
    TIMES("*"),
    MOD("%"),
    DIVIDE("/"),
    AND,
    OR,
    NOT,
    EQUALS("="),
    NOT_EQUALS("<>"),
    LESS_THAN("<"),
    LESS_THAN_OR_EQUALS("<="),
    GREATER_THAN(">"),
    GREATER_THAN_OR_EQUALS(">="),
    IS_NULL("IS NULL"),
    IS_NOT_NULL("IS NOT NULL"),
    IN,
    NOT_IN("NOT IN"),
    LIKE,
    NOT_LIKE("NOT LIKE"),
    FUNC_AND("AND"),
    FUNC_OR("OR"),
    FUNC_XOR("XOR"),
    FUNC_ABS("ABS"),
    FUNC_MOD("MOD"),
    FUNC_CBRT("CBRT"),
    FUNC_CEIL("CEIL"),
    FUNC_FLOOR("FLOOR"),
    FUNC_ACOS("ACOS"),
    FUNC_ASIN("ASIN"),
    FUNC_ATAN("ATAN"),
    FUNC_COS("COS"),
    FUNC_COT("COT"),
    FUNC_SIN("SIN"),
    FUNC_TAN("TAN"),
    FUNC_CONCAT("CONCAT"),
    FUNC_LENGTH("LENGTH"),
    FUNC_LOWER("LOWER"),
    FUNC_UPPER("UPPER"),
    FUNC_SUBSTR("SUBSTR"),
    FUNC_VERSION("VERSION"),
    FUNC_CURRENT_USER("CURRENT_USER"),
    FUNC_CURRENT_SCHEMA("CURRENT_SCHEMA"),
    FUNC_SUM("SUM"),
    FUNC_MAX("MAX"),
    FUNC_MIN("MIN"),
    FUNC_AVG("AVG"),
    FUNC_COUNT("COUNT"),
    FUNC_CAST("CAST"),
    FUNC_TO_CHAR("TO_CHAR"),
    FUNC_TO_DATE("TO_DATE"),
    FUNC_TO_TIME("TO_TIME"),
    FUNC_TO_DATETIME("TO_DATETIME"),
    FUNC_TO_DECIMAL("TO_DECIMAL"),
    FUNC_DATE_ADD("DATE_ADD"),
    FUNC_DATE_SUB("DATE_SUB"),
    FUNC_ADD_WEEKS("ADD_WEEKS"),
    FUNC_SUB_WEEKS("SUB_WEEKS"),
    FUNC_ADD_MONTHS("ADD_MONTHS"),
    FUNC_SUB_MONTHS("SUB_MONTHS"),
    FUNC_ADD_YEARS("ADD_YEARS"),
    FUNC_SUB_YEARS("SUB_YEARS"),
    INPUT_REF;

    public static final SqlKind[] COMPARISON_KINDS;
    public static final SqlKind[] IN_KINDS;
    public static final SqlKind[] TOP_LEVEL;
    public static final SqlKind[] TOP_LEVEL_NONE_REGISTER;
    public static final SqlKind[] QUERY;
    public static final SqlKind[] SET_OP;
    public static final SqlKind[] AGGREGATE_FUNCTIONS;
    public static final SqlKind[] ARITHMETICS;
    public static final SqlKind[] MATH_FUNCTIONS;
    public static final SqlKind[] LOGIC_OP_KINDS;
    public static final SqlKind[] LIKE_KINDS;
    public static final SqlKind[] IS_NULL_KINDS;
    public static final SqlKind[] TO_TYPE_CAST_KINDS;
    public static final SqlKind[] STRING_FUNC_KINDS;
    public static final SqlKind[] FUNCTIONS;
    public static final SqlKind[] SORT_ITEM_ENDING;
    public static final SqlKind[] SHOW;
    private final String name;

    private SqlKind(String name) {
        this.name = name;
    }

    private SqlKind() {
        this.name = this.name();
    }

    public String getName() {
        return this.name;
    }

    public boolean isBelong(SqlKind[] category) {
        for (SqlKind sqlKind : category) {
            if (this != sqlKind) continue;
            return true;
        }
        return false;
    }

    public static SqlKind[] concat(Object ... concat) {
        HashSet<SqlKind> sqlKindSet = new HashSet<SqlKind>(32);
        for (Object o : concat) {
            if (o instanceof SqlKind) {
                sqlKindSet.add((SqlKind)((Object)o));
                continue;
            }
            if (o instanceof SqlKind[]) {
                SqlKind[] array = (SqlKind[])o;
                sqlKindSet.addAll(Lists.newArrayList((Object[])array));
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return sqlKindSet.toArray(new SqlKind[0]);
    }

    static {
        COMPARISON_KINDS = new SqlKind[]{EQUALS, NOT_EQUALS, LESS_THAN, LESS_THAN_OR_EQUALS, GREATER_THAN, GREATER_THAN_OR_EQUALS};
        IN_KINDS = new SqlKind[]{IN, NOT_IN};
        TOP_LEVEL = new SqlKind[]{SELECT, ORDER_BY, UNION};
        TOP_LEVEL_NONE_REGISTER = new SqlKind[]{USE, SHOW_VARIABLES, SET_SESSION_VARIABLE};
        QUERY = new SqlKind[]{SELECT, ORDER_BY};
        SET_OP = new SqlKind[]{UNION};
        AGGREGATE_FUNCTIONS = new SqlKind[]{FUNC_SUM, FUNC_MAX, FUNC_MIN, FUNC_AVG, FUNC_COUNT};
        ARITHMETICS = new SqlKind[]{PLUS, MINUS, TIMES, MOD, DIVIDE};
        MATH_FUNCTIONS = new SqlKind[]{FUNC_AND, FUNC_OR, FUNC_XOR, FUNC_ABS, FUNC_MOD, FUNC_CBRT, FUNC_CEIL, FUNC_FLOOR, FUNC_ACOS, FUNC_ASIN, FUNC_ATAN, FUNC_COS, FUNC_COT, FUNC_SIN, FUNC_TAN};
        LOGIC_OP_KINDS = new SqlKind[]{AND, OR, NOT};
        LIKE_KINDS = new SqlKind[]{LIKE, NOT_LIKE};
        IS_NULL_KINDS = new SqlKind[]{IS_NULL, IS_NOT_NULL};
        TO_TYPE_CAST_KINDS = new SqlKind[]{FUNC_TO_CHAR, FUNC_TO_DATE, FUNC_TO_DATETIME, FUNC_TO_DECIMAL, FUNC_TO_TIME};
        STRING_FUNC_KINDS = new SqlKind[]{FUNC_CONCAT, FUNC_LENGTH, FUNC_LOWER, FUNC_UPPER, FUNC_SUBSTR};
        FUNCTIONS = SqlKind.concat(new Object[]{STRING_FUNC_KINDS, TO_TYPE_CAST_KINDS, MATH_FUNCTIONS, AGGREGATE_FUNCTIONS, FUNC_CAST});
        SORT_ITEM_ENDING = new SqlKind[]{ASCENDING, DESCENDING};
        SHOW = new SqlKind[]{SHOW_DATABASES, SHOW_SESSIONS, SHOW_COLUMNS, SHOW_TABLES, SHOW_SCHEMAS};
    }
}

