/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.flydb.core.sql.tree;

import com.google.common.base.Objects;
import kd.bos.flydb.common.exception.Exceptions;
import kd.bos.flydb.core.sql.tree.SqlKind;
import kd.bos.flydb.core.sql.tree.SqlNode;
import kd.bos.flydb.core.sql.tree.SqlNodeBase;
import kd.bos.flydb.core.sql.tree.SqlParserPosition;
import kd.bos.flydb.core.sql.type.DataType;
import kd.bos.flydb.core.sql.type.DataTypeFactory;
import kd.bos.flydb.core.sql.type.SqlTypeName;
import kd.bos.flydb.core.sql.unparse.SqlWriter;
import kd.bos.flydb.core.sql.util.ASTVisitor;
import kd.bos.flydb.core.sql.validate.SqlValidator;
import kd.bos.flydb.core.sql.validate.SqlValidatorScope;

public class SqlLiteral
extends SqlNodeBase {
    private Object value;
    private DataType dataType;

    public SqlLiteral(SqlParserPosition position, Object value) {
        super(position, SqlKind.LITERAL);
        this.value = value;
        this.dataType = DataTypeFactory.instance.buildString();
    }

    public SqlLiteral(SqlParserPosition position, Object value, DataType dataType) {
        super(position, SqlKind.LITERAL);
        this.value = value;
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static SqlLiteral createSymbol(String name, SqlParserPosition position) {
        return new SqlLiteral(position, name);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
    }

    @Override
    public <T> T accept(ASTVisitor<T> visitor) {
        return visitor.visitSqlLiteral(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlLiteral that = (SqlLiteral)o;
        return Objects.equal((Object)this.value, (Object)that.value) && Objects.equal((Object)this.dataType, (Object)that.dataType);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value, this.dataType});
    }

    @Override
    public boolean equalsOnExpression(SqlNode other) {
        return this.equals(other);
    }

    @Override
    public void unParse(SqlWriter writer, int leftPrecedence, int rightPrecedence) {
        SqlTypeName typeName = this.dataType.getTypeName();
        switch (typeName) {
            case BOOLEAN: {
                writer.keyword(this.value == null ? "UNKNOWN" : (Boolean.parseBoolean(String.valueOf(this.value)) ? "TRUE" : "FALSE"));
                break;
            }
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case STRING: {
                writer.literal(writer.getDialect().quoteStringLiteral(String.valueOf(this.value)));
                break;
            }
            case DECIMAL: 
            case LONG: 
            case INT: {
                throw Exceptions.unParse.unexpected((Enum)typeName);
            }
            case TIME: 
            case DATE: 
            case DATETIME: {
                writer.getDialect().unParseDateTimeLiteral(writer, this, leftPrecedence, rightPrecedence);
                break;
            }
            default: {
                writer.literal(String.valueOf(this.value));
            }
        }
    }

    public String toString() {
        if (this.value == null) {
            return "[NULL]";
        }
        return this.value.toString();
    }
}

